"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPE_TAB_MAPPING = exports.TIME_INTERVAL_OPTIONS = exports.TIME_FIELD = exports.TIMESTAMP = exports.TAB_TITLE = exports.TAB_ID_TXT_PFX = exports.TAB_EVENT_TITLE = exports.TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID = exports.TAB_CREATED_TYPE = exports.TAB_CHART_TITLE = exports.TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID = exports.SPAN = exports.SIMILAR_VIZ_TYPES = exports.SELECTED_TIMESTAMP = exports.SELECTED_QUERY_TAB = exports.SELECTED_PATTERN_FIELD = exports.SELECTED_FIELDS = exports.SELECTED_DATE_RANGE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_ID = exports.ROW_DENSITIES = exports.REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_SEARCH_META_DATA = exports.REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDIRECT_TAB = exports.RAW_QUERY = exports.QUERY_TAB_IDS = exports.QUERIED_FIELDS = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = exports.PIE_YAXIS_GAP = exports.PIE_XAXIS_GAP = exports.PATTERN_REGEX = exports.PATTERNS_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = exports.PARENTFIELDS = exports.PAGE_SIZE = exports.OTEL_TRACE_ID = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.NUMERICAL_TYPES = exports.NUMBER_INPUT_MIN_LIMIT = exports.NEW_TAB = exports.NEW_SELECTED_QUERY_TAB = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_AXIS_MARGIN = exports.METRICS_ANNOTATION = exports.LOG_EXPLORER_BASE_PATH = exports.JAEGER_TRACE_ID = exports.INDEX = exports.HEADER_HEIGHT = exports.HAS_SAVED_TIMESTAMP = exports.GROUPBY = exports.GRID_PAGE_SIZES = exports.GRID_PAGE_RANGE_DISPLAY = exports.GRID_HEADER_COLUMN_MAX_WIDTH = exports.FINAL_QUERY = exports.FILTER_OPTIONS = exports.FILTERED_PATTERN = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = exports.DISABLED_COLOUR = exports.DEFAULT_TIMESTAMP_COLUMN = exports.DEFAULT_SOURCE_COLUMN = exports.DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_EMPTY_EXPLORER_FIELDS = exports.DEFAULT_DATETIME_STRING = exports.DEFAULT_COLUMNS = exports.DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_AVAILABILITY_QUERY = exports.DATE_PICKER_FORMAT = exports.DATE_DISPLAY_FORMAT = exports.DATA_CONFIG_HINTS_INFO = exports.ConfigChartOptionsEnum = exports.CUSTOM_LABEL = exports.CREATE_TAB_PARAM_KEY = exports.CREATE_TAB_PARAM = exports.COLUMN_DEFAULT_MIN_WIDTH = exports.CHILDFIELD = exports.BREAKDOWNS = exports.AVAILABLE_FIELDS = exports.APP_ANALYTICS_TAB_ID_REGEX = exports.AGGREGATION_OPTIONS = exports.AGGREGATIONS = exports.ADD_BUTTON_TEXT = void 0;
exports.sampleLogPatternData = exports.VIZ_CONTAIN_XY_AXIS = exports.VALUEFIELD = exports.UNSELECTED_FIELDS = exports.UNITS_OF_MEASURE = void 0;

var _eui = require("@elastic/eui");

var _shared = require("./shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// URLs
const EVENT_ANALYTICS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/event-analytics/';
exports.EVENT_ANALYTICS_DOCUMENTATION_URL = EVENT_ANALYTICS_DOCUMENTATION_URL;
const OPEN_TELEMETRY_LOG_CORRELATION_LINK = 'https://opentelemetry.io/docs/reference/specification/logs/overview/#log-correlation';
exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = OPEN_TELEMETRY_LOG_CORRELATION_LINK;
const LOG_EXPLORER_BASE_PATH = 'observability-logs#/explorer/';
exports.LOG_EXPLORER_BASE_PATH = LOG_EXPLORER_BASE_PATH;
const RAW_QUERY = 'rawQuery';
exports.RAW_QUERY = RAW_QUERY;
const FINAL_QUERY = 'finalQuery';
exports.FINAL_QUERY = FINAL_QUERY;
const SELECTED_DATE_RANGE = 'selectedDateRange';
exports.SELECTED_DATE_RANGE = SELECTED_DATE_RANGE;
const INDEX = 'index';
exports.INDEX = INDEX;
const SELECTED_PATTERN_FIELD = 'selectedPatternField';
exports.SELECTED_PATTERN_FIELD = SELECTED_PATTERN_FIELD;
const PATTERN_REGEX = 'patternRegex';
exports.PATTERN_REGEX = PATTERN_REGEX;
const FILTERED_PATTERN = 'filteredPattern';
exports.FILTERED_PATTERN = FILTERED_PATTERN;
const SELECTED_TIMESTAMP = 'selectedTimestamp';
exports.SELECTED_TIMESTAMP = SELECTED_TIMESTAMP;
const SELECTED_FIELDS = 'selectedFields';
exports.SELECTED_FIELDS = SELECTED_FIELDS;
const UNSELECTED_FIELDS = 'unselectedFields';
exports.UNSELECTED_FIELDS = UNSELECTED_FIELDS;
const AVAILABLE_FIELDS = 'availableFields';
exports.AVAILABLE_FIELDS = AVAILABLE_FIELDS;
const QUERIED_FIELDS = 'queriedFields';
exports.QUERIED_FIELDS = QUERIED_FIELDS;
const TAB_ID_TXT_PFX = 'explorer-tab-';
exports.TAB_ID_TXT_PFX = TAB_ID_TXT_PFX;
const TAB_TITLE = 'New query';
exports.TAB_TITLE = TAB_TITLE;
const TAB_CHART_TITLE = 'Visualizations';
exports.TAB_CHART_TITLE = TAB_CHART_TITLE;
const TAB_EVENT_TITLE = 'Events';
exports.TAB_EVENT_TITLE = TAB_EVENT_TITLE;
const TAB_EVENT_ID_TXT_PFX = 'main-content-events-';
exports.TAB_EVENT_ID_TXT_PFX = TAB_EVENT_ID_TXT_PFX;
const TAB_CHART_ID_TXT_PFX = 'main-content-vis-';
exports.TAB_CHART_ID_TXT_PFX = TAB_CHART_ID_TXT_PFX;
const TAB_EVENT_ID = 'main-content-events';
exports.TAB_EVENT_ID = TAB_EVENT_ID;
const TAB_CHART_ID = 'main-content-vis';
exports.TAB_CHART_ID = TAB_CHART_ID;
const CREATE_TAB_PARAM_KEY = 'create';
exports.CREATE_TAB_PARAM_KEY = CREATE_TAB_PARAM_KEY;
const CREATE_TAB_PARAM = {
  [TAB_EVENT_ID]: 'events',
  [TAB_CHART_ID]: 'visualizations'
};
exports.CREATE_TAB_PARAM = CREATE_TAB_PARAM;
const HAS_SAVED_TIMESTAMP = 'hasSavedTimestamp';
exports.HAS_SAVED_TIMESTAMP = HAS_SAVED_TIMESTAMP;
const FILTER_OPTIONS = ['Visualization', 'Query', 'Metric'];
exports.FILTER_OPTIONS = FILTER_OPTIONS;
const SAVED_QUERY = 'savedQuery';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = 'savedVisualization';
exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const SAVED_OBJECT_ID = 'savedObjectId';
exports.SAVED_OBJECT_ID = SAVED_OBJECT_ID;
const SAVED_OBJECT_TYPE = 'objectType';
exports.SAVED_OBJECT_TYPE = SAVED_OBJECT_TYPE;
const TAB_CREATED_TYPE = 'tabCreatedType';
exports.TAB_CREATED_TYPE = TAB_CREATED_TYPE;
const NEW_TAB = 'newTab';
exports.NEW_TAB = NEW_TAB;
const REDIRECT_TAB = 'redirect_tab';
exports.REDIRECT_TAB = REDIRECT_TAB;
const PAGE_SIZE = 50;
exports.PAGE_SIZE = PAGE_SIZE;
const DEFAULT_COLUMNS = ['', 'Time', '_source'];
exports.DEFAULT_COLUMNS = DEFAULT_COLUMNS;
const OTEL_TRACE_ID = 'traceId';
exports.OTEL_TRACE_ID = OTEL_TRACE_ID;
const JAEGER_TRACE_ID = 'traceID';
exports.JAEGER_TRACE_ID = JAEGER_TRACE_ID;
const DATE_PICKER_FORMAT = 'YYYY-MM-DD HH:mm:ss';
exports.DATE_PICKER_FORMAT = DATE_PICKER_FORMAT;
const DATE_DISPLAY_FORMAT = 'MMM D, YYYY @ HH:mm:ss.SSS';
exports.DATE_DISPLAY_FORMAT = DATE_DISPLAY_FORMAT;
const DEFAULT_DATETIME_STRING = 'now';
exports.DEFAULT_DATETIME_STRING = DEFAULT_DATETIME_STRING;
const TIME_INTERVAL_OPTIONS = [{
  text: 'Minute',
  value: 'm'
}, {
  text: 'Hour',
  value: 'h'
}, {
  text: 'Day',
  value: 'd'
}, {
  text: 'Week',
  value: 'w'
}, {
  text: 'Month',
  value: 'M'
}, {
  text: 'Year',
  value: 'y'
}]; // redux

exports.TIME_INTERVAL_OPTIONS = TIME_INTERVAL_OPTIONS;
const SELECTED_QUERY_TAB = 'selectedQueryTab';
exports.SELECTED_QUERY_TAB = SELECTED_QUERY_TAB;
const QUERY_TAB_IDS = 'queryTabIds';
exports.QUERY_TAB_IDS = QUERY_TAB_IDS;
const NEW_SELECTED_QUERY_TAB = 'newSelectedQueryTab';
exports.NEW_SELECTED_QUERY_TAB = NEW_SELECTED_QUERY_TAB;
const REDUX_EXPL_SLICE_QUERIES = 'queries';
exports.REDUX_EXPL_SLICE_QUERIES = REDUX_EXPL_SLICE_QUERIES;
const REDUX_EXPL_SLICE_QUERY_RESULT = 'queryResults';
exports.REDUX_EXPL_SLICE_QUERY_RESULT = REDUX_EXPL_SLICE_QUERY_RESULT;
const REDUX_EXPL_SLICE_FIELDS = 'fields';
exports.REDUX_EXPL_SLICE_FIELDS = REDUX_EXPL_SLICE_FIELDS;
const REDUX_EXPL_SLICE_QUERY_TABS = 'queryTabs';
exports.REDUX_EXPL_SLICE_QUERY_TABS = REDUX_EXPL_SLICE_QUERY_TABS;
const REDUX_EXPL_SLICE_VISUALIZATION = 'explorerVisualization';
exports.REDUX_EXPL_SLICE_VISUALIZATION = REDUX_EXPL_SLICE_VISUALIZATION;
const REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = 'countDistributionVisualization';
exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = REDUX_EXPL_SLICE_COUNT_DISTRIBUTION;
const REDUX_EXPL_SLICE_PATTERNS = 'patterns';
exports.REDUX_EXPL_SLICE_PATTERNS = REDUX_EXPL_SLICE_PATTERNS;
const REDUX_EXPL_SLICE_SEARCH_META_DATA = 'searchMetaData';
exports.REDUX_EXPL_SLICE_SEARCH_META_DATA = REDUX_EXPL_SLICE_SEARCH_META_DATA;
const PLOTLY_GAUGE_COLUMN_NUMBER = 4;
exports.PLOTLY_GAUGE_COLUMN_NUMBER = PLOTLY_GAUGE_COLUMN_NUMBER;
const APP_ANALYTICS_TAB_ID_REGEX = /application-analytics-tab.+/;
exports.APP_ANALYTICS_TAB_ID_REGEX = APP_ANALYTICS_TAB_ID_REGEX;
const DEFAULT_AVAILABILITY_QUERY = 'stats count() by span( timestamp, 1h )';
exports.DEFAULT_AVAILABILITY_QUERY = DEFAULT_AVAILABILITY_QUERY;
const PPL_DEFAULT_PATTERN_REGEX_FILETER = '[a-zA-Z\\d]'; // Greedily matches the longest substring for example (patterns referer | patterns pattern='[0-9]' message | where ...) used to modify the query for patterns table

exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = PPL_DEFAULT_PATTERN_REGEX_FILETER;
const PATTERNS_REGEX = /\|\s*patterns.+?\|.*\s*where\s+patterns_field\s*\=\s*'[^a-zA-Z0-9]+'/; // Used to extract the initial pattern applied

exports.PATTERNS_REGEX = PATTERNS_REGEX;
const PATTERNS_EXTRACTOR_REGEX = /patterns\s+(?<pattern>\S+)/;
exports.PATTERNS_EXTRACTOR_REGEX = PATTERNS_EXTRACTOR_REGEX;
const ADD_BUTTON_TEXT = '+ Add color theme';
exports.ADD_BUTTON_TEXT = ADD_BUTTON_TEXT;
const NUMBER_INPUT_MIN_LIMIT = 1;
exports.NUMBER_INPUT_MIN_LIMIT = NUMBER_INPUT_MIN_LIMIT;
const VIZ_CONTAIN_XY_AXIS = [_shared.VIS_CHART_TYPES.Bar, _shared.VIS_CHART_TYPES.Histogram, _shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Pie, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar]; // default ppl aggregation method options

exports.VIZ_CONTAIN_XY_AXIS = VIZ_CONTAIN_XY_AXIS;
const AGGREGATION_OPTIONS = [{
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}, {
  label: 'var_samp'
}, {
  label: 'var_pop'
}, {
  label: 'stddev_samp'
}, {
  label: 'stddev_pop'
}]; // numeric fields type for metrics

exports.AGGREGATION_OPTIONS = AGGREGATION_OPTIONS;
const NUMERICAL_TYPES = ['float', 'double', 'bigint', 'long', 'octet', 'short', 'byte', 'integer']; // Data table constants

exports.NUMERICAL_TYPES = NUMERICAL_TYPES;
const GRID_HEADER_COLUMN_MAX_WIDTH = '150px';
exports.GRID_HEADER_COLUMN_MAX_WIDTH = GRID_HEADER_COLUMN_MAX_WIDTH;
const GRID_PAGE_RANGE_DISPLAY = 5;
exports.GRID_PAGE_RANGE_DISPLAY = GRID_PAGE_RANGE_DISPLAY;
const COLUMN_DEFAULT_MIN_WIDTH = 100;
exports.COLUMN_DEFAULT_MIN_WIDTH = COLUMN_DEFAULT_MIN_WIDTH;
const GRID_PAGE_SIZES = [10, 50, 100];
exports.GRID_PAGE_SIZES = GRID_PAGE_SIZES;
const ROW_DENSITIES = [{
  icon: 'tableDensityExpanded',
  height: 55,
  selected: false
}, {
  icon: 'tableDensityNormal',
  height: 45,
  selected: false
}, {
  icon: 'tableDensityCompact',
  height: 35,
  selected: true
}];
exports.ROW_DENSITIES = ROW_DENSITIES;
const HEADER_HEIGHT = 35; // gauge chart default parameters

exports.HEADER_HEIGHT = HEADER_HEIGHT;
const DEFAULT_GAUGE_CHART_PARAMETERS = {
  GaugeTitleSize: 14,
  DisplayDefaultGauges: 1,
  OrientationDefault: 'h',
  TickLength: 5,
  LegendPlacement: 'center',
  ThresholdsMaxLimit: 1
}; // pie chart default parameters

exports.DEFAULT_GAUGE_CHART_PARAMETERS = DEFAULT_GAUGE_CHART_PARAMETERS;
const PLOTLY_PIE_COLUMN_NUMBER = 2;
exports.PLOTLY_PIE_COLUMN_NUMBER = PLOTLY_PIE_COLUMN_NUMBER;
const PIE_XAXIS_GAP = 0.2;
exports.PIE_XAXIS_GAP = PIE_XAXIS_GAP;
const PIE_YAXIS_GAP = 0.1;
exports.PIE_YAXIS_GAP = PIE_YAXIS_GAP;
const DEFAULT_PIE_CHART_PARAMETERS = {
  DefaultMode: 'pie'
};
exports.DEFAULT_PIE_CHART_PARAMETERS = DEFAULT_PIE_CHART_PARAMETERS;
const GROUPBY = 'dimensions';
exports.GROUPBY = GROUPBY;
const AGGREGATIONS = 'series';
exports.AGGREGATIONS = AGGREGATIONS;
const PARENTFIELDS = 'parentFields';
exports.PARENTFIELDS = PARENTFIELDS;
const VALUEFIELD = 'valueField';
exports.VALUEFIELD = VALUEFIELD;
const CHILDFIELD = 'childField';
exports.CHILDFIELD = CHILDFIELD;
const TIMESTAMP = 'timestamp'; // metrics constants

exports.TIMESTAMP = TIMESTAMP;
const METRICS_GRID_SPACE_BETWEEN_X_AXIS = 0.01;
exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = METRICS_GRID_SPACE_BETWEEN_X_AXIS;
const METRICS_GRID_SPACE_BETWEEN_Y_AXIS = 100;
exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = METRICS_GRID_SPACE_BETWEEN_Y_AXIS;
const METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = 0.08;
exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = METRICS_REDUCE_VALUE_SIZE_PERCENTAGE;
const METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = 0.05;
exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = METRICS_REDUCE_TITLE_SIZE_PERCENTAGE;
const METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = 0.2;
exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE;
const METRICS_SERIES_UNIT_SUBSTRING_LENGTH = 3;
exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = METRICS_SERIES_UNIT_SUBSTRING_LENGTH;
const METRICS_AXIS_MARGIN = {
  l: 0,
  r: 0,
  b: 0,
  t: 80
};
exports.METRICS_AXIS_MARGIN = METRICS_AXIS_MARGIN;
const METRICS_ANNOTATION = {
  xref: 'paper',
  yref: 'paper',
  showarrow: false
};
exports.METRICS_ANNOTATION = METRICS_ANNOTATION;
const DEFAULT_METRICS_CHART_PARAMETERS = {
  DefaultTextMode: 'auto',
  DefaultOrientation: 'auto',
  DefaultTitleSize: 30,
  DefaultValueSize: 80,
  DefaultChartType: 'auto',
  TextAlignment: 'auto',
  DefaultPrecision: 1,
  BaseThreshold: {
    thid: (0, _eui.htmlIdGenerator)('thr')(),
    name: 'Base',
    color: '#3CA1C7',
    value: 0,
    isReadOnly: true
  },
  DefaultTextColor: '#FFFFFF'
};
exports.DEFAULT_METRICS_CHART_PARAMETERS = DEFAULT_METRICS_CHART_PARAMETERS;
const DEFAULT_BAR_CHART_STYLES = {
  BarMode: 'group',
  GroupWidth: 0.7,
  BarWidth: 0.97,
  LabelSize: 12
};
exports.DEFAULT_BAR_CHART_STYLES = DEFAULT_BAR_CHART_STYLES;
const SIMILAR_VIZ_TYPES = [_shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar, _shared.VIS_CHART_TYPES.Bar];
exports.SIMILAR_VIZ_TYPES = SIMILAR_VIZ_TYPES;
let ConfigChartOptionsEnum;
exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum;

(function (ConfigChartOptionsEnum) {
  ConfigChartOptionsEnum["palettePicker"] = "palettePicker";
  ConfigChartOptionsEnum["singleColorPicker"] = "singleColorPicker";
  ConfigChartOptionsEnum["colorpicker"] = "colorpicker";
  ConfigChartOptionsEnum["treemapColorPicker"] = "treemapColorPicker";
  ConfigChartOptionsEnum["input"] = "input";
  ConfigChartOptionsEnum["textInput"] = "textInput";
  ConfigChartOptionsEnum["slider"] = "slider";
  ConfigChartOptionsEnum["switchButton"] = "switchButton";
  ConfigChartOptionsEnum["buttons"] = "buttons";
})(ConfigChartOptionsEnum || (exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum = {}));

const CUSTOM_LABEL = 'customLabel';
exports.CUSTOM_LABEL = CUSTOM_LABEL;
const BREAKDOWNS = 'breakdowns';
exports.BREAKDOWNS = BREAKDOWNS;
const SPAN = 'span';
exports.SPAN = SPAN;
const TIME_FIELD = 'time_field';
exports.TIME_FIELD = TIME_FIELD;
const DISABLED_COLOUR = '#fafbfd';
exports.DISABLED_COLOUR = DISABLED_COLOUR;
const DATA_CONFIG_HINTS_INFO = {
  [AGGREGATIONS]: 'Series is an aggregation function (mandatory). The argument of an aggregation must be a field.',
  [GROUPBY]: "Dimensions are 'by' clauses. They are fields or expressions like scalar and aggregation functions. Besides, the span clause for a dimension can be used to split a specific field into buckets in the same interval, the stats then does the aggregation by these span buckets.",
  [BREAKDOWNS]: "Defines how each series is broken down. Breakdowns are 'by' clauses that subdivide the existing series."
}; // Metrics constants

exports.DATA_CONFIG_HINTS_INFO = DATA_CONFIG_HINTS_INFO;
const UNITS_OF_MEASURE = ['seconds (s)', 'hours (h)', 'celsius (C)', 'farenheit (F)', 'meters (m)', 'kilometers (k)'];
exports.UNITS_OF_MEASURE = UNITS_OF_MEASURE;
const sampleLogPatternData = {
  count: 5,
  pattern: '[a-zA-Zd]',
  sampleLog: '218.148.135.12 - - [2018-07-22T04:18:12.345Z] "GET /beats/filebeat/filebeat-6.3.2-linux-x86_64.tar.gz_1 HTTP/1.1" 200 4531 "-" \
           "Mozilla/5.0 (X11; Linux x86_64; rv:6.0a1) Gecko/20110421 Firefox/6.0a1"',
  anomalyCount: 0
};
exports.sampleLogPatternData = sampleLogPatternData;
const TYPE_TAB_MAPPING = {
  [SAVED_QUERY]: TAB_EVENT_ID,
  [SAVED_VISUALIZATION]: TAB_CHART_ID
};
exports.TYPE_TAB_MAPPING = TYPE_TAB_MAPPING;
const DEFAULT_EMPTY_EXPLORER_FIELDS = [{
  name: 'timestamp',
  type: 'timestamp'
}, {
  name: '_source',
  type: 'string'
}];
exports.DEFAULT_EMPTY_EXPLORER_FIELDS = DEFAULT_EMPTY_EXPLORER_FIELDS;
const DEFAULT_TIMESTAMP_COLUMN = {
  id: 'timestamp',
  isSortable: true,
  display: 'Time',
  schema: 'datetime',
  initialWidth: 200
};
exports.DEFAULT_TIMESTAMP_COLUMN = DEFAULT_TIMESTAMP_COLUMN;
const DEFAULT_SOURCE_COLUMN = {
  id: '_source',
  isSortable: false,
  display: 'Source',
  schema: '_source'
};
exports.DEFAULT_SOURCE_COLUMN = DEFAULT_SOURCE_COLUMN;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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