"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPplRoute = registerPplRoute;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerPplRoute({
  router,
  facet
}) {
  router.post({
    path: `${_shared.PPL_BASE}${_shared.PPL_SEARCH}`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        format: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    const queryRes = await facet.describeQuery(req);

    if (queryRes.success) {
      const result = {
        body: { ...queryRes.data
        }
      };
      return res.ok(result);
    }

    return res.custom({
      statusCode: queryRes.data.statusCode || queryRes.data.status || 500,
      body: queryRes.data.body || queryRes.data.message || ''
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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