/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import org.traccar.ExtendedObjectDecoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.database.CommandsManager;
import org.traccar.database.MediaManager;
import org.traccar.database.StatisticsManager;
import org.traccar.helper.UnitsConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;
import org.traccar.model.Position;
import org.traccar.session.ConnectionManager;
import org.traccar.session.DeviceSession;
import org.traccar.session.cache.CacheManager;

public abstract class BaseProtocolDecoder
extends ExtendedObjectDecoder {
    private static final String PROTOCOL_UNKNOWN = "unknown";
    private final Protocol protocol;
    private CacheManager cacheManager;
    private ConnectionManager connectionManager;
    private StatisticsManager statisticsManager;
    private MediaManager mediaManager;
    private CommandsManager commandsManager;

    public BaseProtocolDecoder(Protocol protocol) {
        this.protocol = protocol;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Inject
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Inject
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Inject
    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    @Inject
    public void setMediaManager(MediaManager mediaManager) {
        this.mediaManager = mediaManager;
    }

    @Inject
    public void setCommandsManager(CommandsManager commandsManager) {
        this.commandsManager = commandsManager;
    }

    public CommandsManager getCommandsManager() {
        return this.commandsManager;
    }

    public String writeMediaFile(String uniqueId, ByteBuf buf, String extension) {
        return this.mediaManager.writeFile(uniqueId, buf, extension);
    }

    public String getProtocolName() {
        return this.protocol != null ? this.protocol.getName() : PROTOCOL_UNKNOWN;
    }

    public String getServer(Channel channel, char delimiter) {
        Object server = this.getConfig().getString(Keys.PROTOCOL_SERVER.withPrefix(this.getProtocolName()));
        if (server == null && channel != null) {
            InetSocketAddress address = (InetSocketAddress)channel.localAddress();
            server = address.getAddress().getHostAddress() + ":" + address.getPort();
        }
        return server != null ? ((String)server).replace(':', delimiter) : null;
    }

    protected double convertSpeed(double value, String defaultUnits) {
        switch (this.getConfig().getString(this.getProtocolName() + ".speed", defaultUnits)) {
            case "kmh": {
                return UnitsConverter.knotsFromKph(value);
            }
            case "mps": {
                return UnitsConverter.knotsFromMps(value);
            }
            case "mph": {
                return UnitsConverter.knotsFromMph(value);
            }
        }
        return value;
    }

    protected TimeZone getTimeZone(long deviceId) {
        return this.getTimeZone(deviceId, "UTC");
    }

    protected TimeZone getTimeZone(long deviceId, String defaultTimeZone) {
        String timeZoneName = AttributeUtil.lookup(this.cacheManager, Keys.DECODER_TIMEZONE, deviceId);
        if (timeZoneName != null) {
            return TimeZone.getTimeZone(timeZoneName);
        }
        if (defaultTimeZone != null) {
            return TimeZone.getTimeZone(defaultTimeZone);
        }
        return null;
    }

    public DeviceSession getDeviceSession(Channel channel, SocketAddress remoteAddress, String ... uniqueIds) {
        try {
            return this.connectionManager.getDeviceSession(this.protocol, channel, remoteAddress, uniqueIds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void getLastLocation(Position position, Date deviceTime) {
        if (position.getDeviceId() != 0L) {
            position.setOutdated(true);
            Position last = this.cacheManager.getPosition(position.getDeviceId());
            if (last != null) {
                position.setFixTime(last.getFixTime());
                position.setValid(last.getValid());
                position.setLatitude(last.getLatitude());
                position.setLongitude(last.getLongitude());
                position.setAltitude(last.getAltitude());
                position.setSpeed(last.getSpeed());
                position.setCourse(last.getCourse());
                position.setAccuracy(last.getAccuracy());
            } else {
                position.setFixTime(new Date(0L));
            }
            if (deviceTime != null) {
                position.setDeviceTime(deviceTime);
            } else {
                position.setDeviceTime(new Date());
            }
        }
    }

    @Override
    protected void onMessageEvent(Channel channel, SocketAddress remoteAddress, Object originalMessage, Object decodedMessage) {
        DeviceSession deviceSession;
        if (this.statisticsManager != null) {
            this.statisticsManager.registerMessageReceived();
        }
        HashSet<Long> deviceIds = new HashSet<Long>();
        if (decodedMessage != null) {
            if (decodedMessage instanceof Position) {
                deviceIds.add(((Position)decodedMessage).getDeviceId());
            } else if (decodedMessage instanceof Collection) {
                Collection positions = (Collection)decodedMessage;
                for (Position position : positions) {
                    deviceIds.add(position.getDeviceId());
                }
            }
        }
        if (deviceIds.isEmpty() && (deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0])) != null) {
            deviceIds.add(deviceSession.getDeviceId());
        }
        Iterator iterator = deviceIds.iterator();
        while (iterator.hasNext()) {
            long deviceId = (Long)iterator.next();
            this.connectionManager.updateDevice(deviceId, "online", new Date());
            this.sendQueuedCommands(channel, remoteAddress, deviceId);
        }
    }

    protected void sendQueuedCommands(Channel channel, SocketAddress remoteAddress, long deviceId) {
        for (Command command : this.commandsManager.readQueuedCommands(deviceId)) {
            this.protocol.sendDataCommand(channel, remoteAddress, command);
        }
    }

    @Override
    protected Object handleEmptyMessage(Channel channel, SocketAddress remoteAddress, Object msg) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (this.getConfig().getBoolean(Keys.DATABASE_SAVE_EMPTY) && deviceSession != null) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            return position;
        }
        return null;
    }
}

