/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class SviasProtocolEncoder
extends StringProtocolEncoder {
    public SviasProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.formatCommand(command, "%s", "data");
            }
            case "positionSingle": {
                return this.formatCommand(command, "AT+STR=1*", new String[0]);
            }
            case "setOdometer": {
                return this.formatCommand(command, "AT+ODT=%s*", "data");
            }
            case "engineStop": {
                return this.formatCommand(command, "AT+OUT=1,1*", new String[0]);
            }
            case "engineResume": {
                return this.formatCommand(command, "AT+OUT=1,0*", new String[0]);
            }
            case "alarmArm": {
                return this.formatCommand(command, "AT+OUT=2,1*", new String[0]);
            }
            case "alarmDisarm": {
                return this.formatCommand(command, "AT+OUT=2,0*", new String[0]);
            }
            case "alarmRemove": {
                return this.formatCommand(command, "AT+PNC=600*", new String[0]);
            }
        }
        return null;
    }
}

