/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class Tlt2hProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_HEADER = new PatternBuilder().number("#(d+)").expression("#[^#]*").number("#d*").groupBegin().number("#([01])").number("#(d+)").number("#(d+)").number("#(d+)").number("#(d+)").groupEnd("?").expression("#([^#]+)").number("#d+").compile();
    private static final Pattern PATTERN_POSITION = new PatternBuilder().text("#").number("(?:(dd|dddd)|x*)").groupBegin().number("#(d+),").number("(d+),").number("(x+),").number("(x+)").groupEnd("?").text("$GPRMC,").number("(dd)(dd)(dd).d+,").expression("([AVL]),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").number("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(dd)(dd)(dd)").any().compile();
    private static final Pattern PATTERN_WIFI = new PatternBuilder().text("#").number("(?:(dd|dddd)|x+)").expression("#?").groupBegin().number("(d+),").number("(d+),").number("(x+),").number("(x+)").groupEnd("?").text("$WIFI,").number("(dd)(dd)(dd).d+,").expression("[AVL],").expression("(.*)").number("(dd)(dd)(dd)").text("*").number("xx").compile();

    public Tlt2hProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeStatus(Position position, String status) {
        switch (status) {
            case "AUTOSTART": 
            case "AUTO": {
                position.set("ignition", true);
                break;
            }
            case "AUTOSTOP": 
            case "AUTOLOW": {
                position.set("ignition", false);
                break;
            }
            case "TOWED": {
                position.set("alarm", "tow");
                break;
            }
            case "SOS": {
                position.set("alarm", "sos");
                break;
            }
            case "DEF": {
                position.set("alarm", "powerCut");
                break;
            }
            case "BLP": {
                position.set("alarm", "lowBattery");
                break;
            }
            case "CLP": {
                position.set("alarm", "lowPower");
                break;
            }
            case "OS": {
                position.set("alarm", "geofenceExit");
                break;
            }
            case "RS": {
                position.set("alarm", "geofenceEnter");
                break;
            }
            case "OVERSPEED": {
                position.set("alarm", "overspeed");
                break;
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        String header = (sentence = sentence.trim()).substring(0, sentence.indexOf(13));
        Parser parser = new Parser(PATTERN_HEADER, header);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Boolean door = null;
        Double adc = null;
        Double power = null;
        Double battery = null;
        Double temperature = null;
        if (parser.hasNext(5)) {
            door = parser.nextInt() == 1;
            adc = (double)parser.nextInt().intValue() * 0.1;
            power = (double)parser.nextInt().intValue() * 0.1;
            battery = (double)parser.nextInt().intValue() * 0.1;
            temperature = (double)parser.nextInt().intValue() * 0.1;
        }
        String status = parser.next();
        String[] messages = sentence.substring(sentence.indexOf(10) + 1).split("\r\n");
        LinkedList<Position> positions = new LinkedList<Position>();
        for (String message : messages) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            if (message.contains("$GPRMC")) {
                parser = new Parser(PATTERN_POSITION, message);
                if (!parser.matches()) continue;
                if (parser.hasNext()) {
                    int voltage = parser.nextInt();
                    position.set("battery", voltage > 100 ? (double)voltage * 0.001 : (double)voltage * 0.1);
                }
                if (parser.hasNext(4)) {
                    Network network = new Network();
                    network.addCellTower(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue()));
                    position.setNetwork(network);
                }
                DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
                position.setValid(parser.next().equals("A"));
                position.setLatitude(parser.nextCoordinate());
                position.setLongitude(parser.nextCoordinate());
                position.setSpeed(parser.nextDouble(0.0));
                position.setCourse(parser.nextDouble(0.0));
                dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
                position.setTime(dateBuilder.getDate());
            } else if (message.contains("$WIFI")) {
                parser = new Parser(PATTERN_WIFI, message);
                if (!parser.matches()) continue;
                if (parser.hasNext()) {
                    int voltage = parser.nextInt();
                    position.set("battery", voltage > 100 ? (double)voltage * 0.001 : (double)voltage * 0.1);
                }
                Network network = new Network();
                if (parser.hasNext(4)) {
                    network.addCellTower(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue()));
                }
                DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
                String[] values = parser.next().split(",");
                for (int i = 0; i < values.length / 2; ++i) {
                    String mac = values[i * 2 + 1].replaceAll("(..)", "$1:").substring(0, 17);
                    network.addWifiAccessPoint(WifiAccessPoint.from(mac, Integer.parseInt(values[i * 2])));
                }
                position.setNetwork(network);
                dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
                this.getLastLocation(position, dateBuilder.getDate());
            } else {
                this.getLastLocation(position, null);
            }
            position.set("door", door);
            position.set("adc1", adc);
            position.set("power", power);
            position.set("battery", battery);
            position.set("temp1", temperature);
            this.decodeStatus(position, status);
            positions.add(position);
        }
        return positions.isEmpty() ? null : positions;
    }
}

