/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class WristbandProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("..").number("(d+)|").number("([vV]d+.d+)|").number("d+|").text("{").number("F(d+)").groupBegin().text("#").expression("(.*)").groupEnd("?").text("}").text("\r\n").compile();

    public WristbandProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, String imei, String version, int type, String data) {
        if (channel != null) {
            String sentence = String.format("YX%s|%s|0|{F%02d#%s}\r\n", imei, version, type, data);
            ByteBuf response = Unpooled.buffer();
            response.writeBytes(new byte[]{0, 1, 2});
            response.writeShort(sentence.length());
            response.writeCharSequence((CharSequence)sentence, StandardCharsets.US_ASCII);
            response.writeBytes(new byte[]{-1, -2, -4});
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private Position decodePosition(DeviceSession deviceSession, String sentence) throws ParseException {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String[] values = sentence.split(",");
        position.setValid(true);
        position.setLongitude(Double.parseDouble(values[0]));
        position.setLatitude(Double.parseDouble(values[1]));
        position.setTime(new SimpleDateFormat("yyyyMMddHHmm").parse(values[2]));
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[3])));
        return position;
    }

    private Position decodeStatus(DeviceSession deviceSession, String sentence) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("batteryLevel", Integer.parseInt(sentence.split(",")[0]));
        return position;
    }

    private Position decodeNetwork(DeviceSession deviceSession, String sentence, boolean wifi) {
        String[] values;
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        Network network = new Network();
        String[] fragments = sentence.split("\\|");
        if (wifi) {
            for (String item : fragments[0].split("_")) {
                values = item.split(",");
                network.addWifiAccessPoint(WifiAccessPoint.from(values[0], Integer.parseInt(values[1])));
            }
        }
        for (String item : fragments[wifi ? 1 : 0].split(":")) {
            values = item.split(",");
            int lac = Integer.parseInt(values[0]);
            int mnc = Integer.parseInt(values[1]);
            int mcc = Integer.parseInt(values[2]);
            int cid = Integer.parseInt(values[3]);
            int rssi = Integer.parseInt(values[4]);
            network.addCellTower(CellTower.from(mcc, mnc, lac, cid, rssi));
        }
        position.setNetwork(network);
        return position;
    }

    private List<Position> decodeMessage(Channel channel, SocketAddress remoteAddress, String sentence) throws ParseException {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        String version = parser.next();
        int type = parser.nextInt();
        LinkedList<Position> positions = new LinkedList<Position>();
        String data = parser.next();
        switch (type) {
            case 90: {
                this.sendResponse(channel, imei, version, type, this.getServer(channel, ','));
                break;
            }
            case 91: {
                String time = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
                this.sendResponse(channel, imei, version, type, time + "|" + this.getServer(channel, ','));
                break;
            }
            case 1: {
                positions.add(this.decodeStatus(deviceSession, data));
                this.sendResponse(channel, imei, version, type, data.split(",")[1]);
                break;
            }
            case 2: {
                for (String fragment : data.split("\\|")) {
                    positions.add(this.decodePosition(deviceSession, fragment));
                }
                break;
            }
            case 3: 
            case 4: {
                positions.add(this.decodeNetwork(deviceSession, data, type == 3));
                break;
            }
            case 64: {
                this.sendResponse(channel, imei, version, type, data);
                break;
            }
        }
        return positions.isEmpty() ? null : positions;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(3);
        buf.readUnsignedShort();
        String sentence = buf.toString(buf.readerIndex(), buf.readableBytes() - 3, StandardCharsets.US_ASCII);
        buf.skipBytes(3);
        return this.decodeMessage(channel, remoteAddress, sentence);
    }
}

