"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupOpensearchRoutes = setupOpensearchRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupOpensearchRoutes(services, router) {
  const {
    opensearchService
  } = services;
  router.get({
    path: `${_constants.API.DOCUMENT_IDS_QUERY}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, opensearchService.documentIdsQuery);
  router.get({
    path: `${_constants.API.TIME_RANGE_QUERY}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, opensearchService.timeRangeQuery);
  router.get({
    path: `${_constants.API.PLUGINS}`,
    validate: false
  }, opensearchService.getPlugins);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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