"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingPlugin = void 0;

var _operators = require("rxjs/operators");

var _clusters = require("./clusters");

var _services = require("./services");

var _routes = require("../server/routes");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AlertingPlugin {
  constructor(initializerContext) {
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }

  async setup(core) {
    // Get the global configuration settings of the cluster
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise(); // Create clusters

    const alertingESClient = (0, _clusters.createAlertingCluster)(core, globalConfig);
    const adESClient = (0, _clusters.createAlertingADCluster)(core, globalConfig); // Initialize services

    const alertService = new _services.AlertService(alertingESClient);
    const opensearchService = new _services.OpensearchService(alertingESClient);
    const monitorService = new _services.MonitorService(alertingESClient);
    const destinationsService = new _services.DestinationsService(alertingESClient);
    const anomalyDetectorService = new _services.AnomalyDetectorService(adESClient);
    const findingService = new _services.FindingService(alertingESClient);
    const services = {
      alertService,
      destinationsService,
      opensearchService,
      monitorService,
      anomalyDetectorService,
      findingService
    }; // Create router

    const router = core.http.createRouter(); // Add server routes

    (0, _routes.alerts)(services, router);
    (0, _routes.destinations)(services, router);
    (0, _routes.opensearch)(services, router);
    (0, _routes.monitors)(services, router);
    (0, _routes.detectors)(services, router);
    (0, _routes.findings)(services, router);
    return {};
  }

  async start(core) {
    return {};
  }

}

exports.AlertingPlugin = AlertingPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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