"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
exports.plugin = plugin;

var _configSchema = require("@osd/config-schema");

var _plugin = require("./plugin");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  })
});

exports.configSchema = configSchema;
const config = {
  exposeToBrowser: {
    enabled: true
  },
  schema: configSchema
};
exports.config = config;

function plugin(initializerContext) {
  return new _plugin.IndexPatternManagementPlugin();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluZGV4LnRzIl0sIm5hbWVzIjpbImNvbmZpZ1NjaGVtYSIsInNjaGVtYSIsIm9iamVjdCIsImVuYWJsZWQiLCJib29sZWFuIiwiZGVmYXVsdFZhbHVlIiwiY29uZmlnIiwiZXhwb3NlVG9Ccm93c2VyIiwicGx1Z2luIiwiaW5pdGlhbGl6ZXJDb250ZXh0IiwiSW5kZXhQYXR0ZXJuTWFuYWdlbWVudFBsdWdpbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFLQTs7QUFFQTs7QUFQQTtBQUNBO0FBQ0E7QUFDQTtBQU1PLE1BQU1BLFlBQVksR0FBR0MscUJBQU9DLE1BQVAsQ0FBYztBQUN4Q0MsRUFBQUEsT0FBTyxFQUFFRixxQkFBT0csT0FBUCxDQUFlO0FBQUVDLElBQUFBLFlBQVksRUFBRTtBQUFoQixHQUFmO0FBRCtCLENBQWQsQ0FBckI7OztBQU1BLE1BQU1DLE1BQStELEdBQUc7QUFDN0VDLEVBQUFBLGVBQWUsRUFBRTtBQUNmSixJQUFBQSxPQUFPLEVBQUU7QUFETSxHQUQ0RDtBQUk3RUYsRUFBQUEsTUFBTSxFQUFFRDtBQUpxRSxDQUF4RTs7O0FBVUEsU0FBU1EsTUFBVCxDQUFnQkMsa0JBQWhCLEVBQThEO0FBQ25FLFNBQU8sSUFBSUMsb0NBQUosRUFBUDtBQUNEIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEsIFR5cGVPZiB9IGZyb20gXCJAb3NkL2NvbmZpZy1zY2hlbWFcIjtcbmltcG9ydCB7IFBsdWdpbkNvbmZpZ0Rlc2NyaXB0b3IsIFBsdWdpbkluaXRpYWxpemVyQ29udGV4dCB9IGZyb20gXCIuLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXJcIjtcbmltcG9ydCB7IEluZGV4UGF0dGVybk1hbmFnZW1lbnRQbHVnaW4gfSBmcm9tIFwiLi9wbHVnaW5cIjtcblxuZXhwb3J0IGNvbnN0IGNvbmZpZ1NjaGVtYSA9IHNjaGVtYS5vYmplY3Qoe1xuICBlbmFibGVkOiBzY2hlbWEuYm9vbGVhbih7IGRlZmF1bHRWYWx1ZTogdHJ1ZSB9KSxcbn0pO1xuXG5leHBvcnQgdHlwZSBJbmRleE1hbmFnZW1lbnRQbHVnaW5Db25maWdUeXBlID0gVHlwZU9mPHR5cGVvZiBjb25maWdTY2hlbWE+O1xuXG5leHBvcnQgY29uc3QgY29uZmlnOiBQbHVnaW5Db25maWdEZXNjcmlwdG9yPEluZGV4TWFuYWdlbWVudFBsdWdpbkNvbmZpZ1R5cGU+ID0ge1xuICBleHBvc2VUb0Jyb3dzZXI6IHtcbiAgICBlbmFibGVkOiB0cnVlLFxuICB9LFxuICBzY2hlbWE6IGNvbmZpZ1NjaGVtYSxcbn07XG5cbmV4cG9ydCBpbnRlcmZhY2UgSW5kZXhNYW5hZ2VtZW50UGx1Z2luU2V0dXAge31cbmV4cG9ydCBpbnRlcmZhY2UgSW5kZXhNYW5hZ2VtZW50UGx1Z2luU3RhcnQge31cblxuZXhwb3J0IGZ1bmN0aW9uIHBsdWdpbihpbml0aWFsaXplckNvbnRleHQ6IFBsdWdpbkluaXRpYWxpemVyQ29udGV4dCkge1xuICByZXR1cm4gbmV3IEluZGV4UGF0dGVybk1hbmFnZW1lbnRQbHVnaW4oKTtcbn1cbiJdfQ==