"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class OpenSearchService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "documentIdsQuery", async (context, request, response) => {
      try {
        const {
          index,
          documentIds
        } = request.query;
        const body = {
          query: {
            terms: {
              _id: documentIds
            }
          }
        };
        const params = {
          index,
          body: JSON.stringify(body)
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const searchResponse = await callWithRequest('search', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - OpenSearchService - documentIdsQuery:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "timeRangeQuery", async (context, request, response) => {
      try {
        const {
          index,
          timeField = 'timestamp',
          startTime = 'now-15m',
          endTime = 'now'
        } = request.query;
        const body = {
          query: {
            range: {
              [timeField]: {
                gte: startTime,
                lt: endTime
              }
            }
          }
        };
        const params = {
          index,
          body: JSON.stringify(body)
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const searchResponse = await callWithRequest('search', params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - OpenSearchService - timeRangeQuery:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "getPlugins", async (context, request, response) => {
      try {
        const {
          callAsCurrentUser
        } = this.osDriver.asScoped(request);
        const plugins = await callAsCurrentUser('cat.plugins', {
          format: 'json',
          h: 'component'
        });
        return response.ok({
          body: {
            ok: true,
            response: plugins
          }
        });
      } catch (error) {
        console.error('Security Analytics - OpensearchService - getPlugins:', error);
        return response.ok({
          body: {
            ok: false,
            response: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Searches the provided index for documents with the provided IDs.
   */


}

exports.default = OpenSearchService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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