/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic;

import ca.sqlpower.architect.ArchitectProject;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.critic.Critic;
import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticGrouping;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.Criticizer;
import ca.sqlpower.architect.ddl.critic.impl.AlphaNumericNameCritic;
import ca.sqlpower.architect.ddl.critic.impl.AlphaNumericSequenceNameCritic;
import ca.sqlpower.architect.ddl.critic.impl.DB2UnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.DuplicateNameCritic;
import ca.sqlpower.architect.ddl.critic.impl.EmptyRelationshipCritic;
import ca.sqlpower.architect.ddl.critic.impl.H2UnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.HSQLDBUnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.MySQLCommentCritic;
import ca.sqlpower.architect.ddl.critic.impl.MySQLReservedWordsCritic;
import ca.sqlpower.architect.ddl.critic.impl.MySQLUnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.OraclePhysicalNameCritic;
import ca.sqlpower.architect.ddl.critic.impl.OracleReservedWordsCritic;
import ca.sqlpower.architect.ddl.critic.impl.OracleUnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.PostgreSQLReservedWordsCritic;
import ca.sqlpower.architect.ddl.critic.impl.PrimaryKeyCritic;
import ca.sqlpower.architect.ddl.critic.impl.RelationshipMappingTypeCritic;
import ca.sqlpower.architect.ddl.critic.impl.SQLServer2000UnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.SQLServer2005UnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.SQLServerReservedWordsCritic;
import ca.sqlpower.architect.ddl.critic.impl.SQLServerUnsupportedFeaturesCritic;
import ca.sqlpower.architect.ddl.critic.impl.SetDefaultOnColumnWithNoDefaultCritic;
import ca.sqlpower.architect.ddl.critic.impl.SetNullOnNonNullableColumnCritic;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class CriticManager
extends AbstractSPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(CriticGrouping.class);
    private final List<CriticAndSettings> STARTING_CRITICS = Collections.unmodifiableList(Arrays.asList(new PrimaryKeyCritic(), new RelationshipMappingTypeCritic(), new EmptyRelationshipCritic(), new AlphaNumericNameCritic(), new AlphaNumericSequenceNameCritic(), new SetDefaultOnColumnWithNoDefaultCritic(), new SetNullOnNonNullableColumnCritic(), new DuplicateNameCritic(), new DB2UnsupportedFeaturesCritic(), new H2UnsupportedFeaturesCritic(), new HSQLDBUnsupportedFeaturesCritic(), new MySQLCommentCritic(), new MySQLReservedWordsCritic(), new MySQLUnsupportedFeaturesCritic(), new OraclePhysicalNameCritic(), new OracleReservedWordsCritic(), new OracleUnsupportedFeaturesCritic(), new PostgreSQLReservedWordsCritic(), new SQLServerUnsupportedFeaturesCritic(), new SQLServerReservedWordsCritic(), new SQLServer2000UnsupportedFeaturesCritic(), new SQLServer2005UnsupportedFeaturesCritic()));
    private final List<CriticGrouping> criticGroupings = new ArrayList<CriticGrouping>();

    @Constructor
    public CriticManager() {
        this.setName("Critic Manager");
    }

    @Transient
    @Accessor
    public List<CriticAndSettings> getStartingCritics() {
        return this.STARTING_CRITICS;
    }

    public void registerStartingCritics() {
        for (CriticAndSettings criticType : this.STARTING_CRITICS) {
            this.registerCritic(criticType);
        }
        this.loadDefaults();
    }

    public void registerCritic(CriticAndSettings critic) {
        for (CriticGrouping grouping : this.criticGroupings) {
            if (!grouping.getPlatformType().equals(critic.getPlatformType())) continue;
            grouping.addChild((SPObject)critic, grouping.getSettings().size());
            return;
        }
        CriticGrouping newGrouping = new CriticGrouping(critic.getPlatformType());
        this.addChild((SPObject)newGrouping, this.criticGroupings.size());
        newGrouping.addChild((SPObject)critic, 0);
    }

    public List<Criticism> criticize() {
        return this.criticize(null);
    }

    public List<Criticism> criticize(Class<? extends DDLGenerator> generatorClass) {
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        criticisms.addAll(this.criticize(generatorClass, this.getParent().getTargetDatabase()));
        for (JDBCDataSourceType dsType : this.getParent().getSession().getDataSources().getDataSourceTypes()) {
            criticisms.addAll(this.criticize(generatorClass, dsType));
        }
        for (JDBCDataSource ds : this.getParent().getSession().getDataSources().getConnections()) {
            criticisms.addAll(this.criticize(generatorClass, ds));
        }
        return criticisms;
    }

    private List<Criticism> criticize(Class<? extends DDLGenerator> generatorClass, Object root) {
        ArrayList<Critic> critics = new ArrayList<Critic>();
        for (CriticGrouping grouping : this.criticGroupings) {
            if (!grouping.isEnabled()) continue;
            CriticAndSettings.StarterPlatformTypes starterTypeByGroupName = CriticAndSettings.StarterPlatformTypes.getByGroupName(grouping.getPlatformType());
            if (generatorClass != null && starterTypeByGroupName != null && !starterTypeByGroupName.isAssociated(generatorClass)) continue;
            for (CriticAndSettings singleSettings : grouping.getSettings()) {
                if (CriticAndSettings.Severity.IGNORE.equals((Object)singleSettings.getSeverity())) continue;
                critics.add(singleSettings);
            }
        }
        Criticizer criticizer = new Criticizer(critics);
        return Collections.unmodifiableList(criticizer.criticize(root));
    }

    protected void addChildImpl(SPObject child, int index) {
        if (!(child instanceof CriticGrouping)) {
            throw new IllegalStateException("Invalid child type " + child);
        }
        CriticGrouping critic = (CriticGrouping)child;
        this.criticGroupings.add(index, critic);
        critic.setParent((SPObject)this);
        this.fireChildAdded(CriticGrouping.class, child, index);
    }

    protected boolean removeChildImpl(SPObject child) {
        int index = this.criticGroupings.indexOf(child);
        boolean removed = this.criticGroupings.remove(child);
        if (removed) {
            this.fireChildRemoved(CriticAndSettings.class, child, index);
        }
        return removed;
    }

    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @NonProperty
    public List<? extends SPObject> getChildren() {
        return Collections.unmodifiableList(this.criticGroupings);
    }

    @NonBound
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
        for (CriticGrouping grouping : this.criticGroupings) {
            grouping.removeDependency(dependency);
        }
    }

    @NonProperty
    public List<CriticGrouping> getCriticGroupings() {
        return Collections.unmodifiableList(this.criticGroupings);
    }

    public void clear() {
        try {
            this.begin("Clearing manager");
            for (int i = this.criticGroupings.size() - 1; i >= 0; --i) {
                this.removeChild((SPObject)this.criticGroupings.get(i));
            }
            this.commit();
        }
        catch (Throwable t) {
            this.rollback(t.getMessage());
            throw new RuntimeException(t);
        }
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (!(parent instanceof ArchitectProject)) {
            throw new IllegalArgumentException("The parent of a critic manager must be some kind of architect project.");
        }
        super.setParent(parent);
    }

    @Accessor
    public ArchitectProject getParent() {
        return (ArchitectProject)super.getParent();
    }

    public void saveAsDefaults() throws BackingStoreException {
        Preferences prefs = Preferences.userNodeForPackage(CriticManager.class);
        prefs.clear();
        for (CriticGrouping group : this.getCriticGroupings()) {
            prefs.putBoolean(CriticGrouping.class.getSimpleName() + "." + group.getPlatformType() + ".enabled", group.isEnabled());
            for (CriticAndSettings settings : group.getSettings()) {
                prefs.put(settings.getClass().getSimpleName() + ".severity", settings.getSeverity().name());
            }
        }
        prefs.flush();
    }

    public void loadDefaults() {
        Preferences prefs = Preferences.userNodeForPackage(CriticManager.class);
        for (CriticGrouping group : this.getCriticGroupings()) {
            group.setEnabled(prefs.getBoolean(CriticGrouping.class.getSimpleName() + "." + group.getPlatformType() + ".enabled", true));
            for (CriticAndSettings settings : group.getSettings()) {
                String severity = prefs.get(settings.getClass().getSimpleName() + ".severity", CriticAndSettings.Severity.ERROR.name());
                settings.setSeverity(CriticAndSettings.Severity.valueOf(severity));
            }
        }
    }
}

