/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SecondParam;
import groovy.transform.stc.SimpleType;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.Dependencies;
import org.gradle.api.artifacts.dsl.DependencyAdder;
import org.gradle.api.artifacts.dsl.DependencyModifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;

public class DependenciesExtensionModule {
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final Set<String> MODULE_LEGAL_MAP_KEYS = ImmutableSet.of((Object)"group", (Object)"name", (Object)"version");

    public static ExternalModuleDependency module(Dependencies self, Map<String, CharSequence> map) {
        if (!MODULE_LEGAL_MAP_KEYS.containsAll(map.keySet())) {
            CollectionUtils.SetDiff diff = CollectionUtils.diffSetsBy(MODULE_LEGAL_MAP_KEYS, map.keySet(), k -> k);
            throw new IllegalArgumentException("The map must not contain the following keys: " + diff.rightOnly);
        }
        if (!map.containsKey(NAME)) {
            throw new IllegalArgumentException("The map must contain a name key.");
        }
        String group = DependenciesExtensionModule.extract(map, GROUP);
        String name = DependenciesExtensionModule.extract(map, NAME);
        String version = DependenciesExtensionModule.extract(map, VERSION);
        assert (name != null);
        return self.module(group, name, version);
    }

    @Nullable
    private static String extract(Map<String, CharSequence> map, String key) {
        return map.containsKey(key) ? map.get(key).toString() : null;
    }

    public static ExternalModuleDependency call(DependencyModifier self, CharSequence dependencyNotation) {
        return self.modify(dependencyNotation);
    }

    public static Provider<? extends MinimalExternalModuleDependency> call(DependencyModifier self, ProviderConvertible<? extends MinimalExternalModuleDependency> providerConvertibleToDependency) {
        return self.modify(providerConvertibleToDependency);
    }

    public static <D extends ModuleDependency> Provider<D> call(DependencyModifier self, Provider<D> providerToDependency) {
        return self.modify(providerToDependency);
    }

    public static <D extends ModuleDependency> D call(DependencyModifier self, D dependency) {
        return (D)self.modify(dependency);
    }

    public static void call(DependencyAdder self, CharSequence dependencyNotation) {
        self.add(dependencyNotation);
    }

    public static void call(DependencyAdder self, CharSequence dependencyNotation, @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.ExternalModuleDependency"}) Closure<?> configuration) {
        self.add(dependencyNotation, ConfigureUtil.configureUsing(configuration));
    }

    public static void call(DependencyAdder self, FileCollection files) {
        self.add(files);
    }

    public static void call(DependencyAdder self, FileCollection files, @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.FileCollectionDependency"}) Closure<?> configuration) {
        self.add(files, ConfigureUtil.configureUsing(configuration));
    }

    public static void call(DependencyAdder self, ProviderConvertible<? extends MinimalExternalModuleDependency> externalModule) {
        self.add(externalModule);
    }

    public static void call(DependencyAdder self, ProviderConvertible<? extends MinimalExternalModuleDependency> externalModule, @ClosureParams(value=SimpleType.class, options={"org.gradle.api.artifacts.ExternalModuleDependency"}) Closure<?> configuration) {
        self.add(externalModule, ConfigureUtil.configureUsing(configuration));
    }

    public static void call(DependencyAdder self, Dependency dependency) {
        self.add(dependency);
    }

    public static <D extends Dependency> void call(DependencyAdder self, D dependency, @ClosureParams(value=SecondParam.class) Closure<?> configuration) {
        self.add(dependency, ConfigureUtil.configureUsing(configuration));
    }

    public static void call(DependencyAdder self, Provider<? extends Dependency> dependency) {
        self.add(dependency);
    }

    public static <D extends Dependency> void call(DependencyAdder self, Provider<? extends D> dependency, @ClosureParams(value=SecondParam.FirstGenericType.class) Closure<?> configuration) {
        self.add(dependency, ConfigureUtil.configureUsing(configuration));
    }
}

