/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.buildtree.NestedBuildTree;
import org.gradle.internal.service.ServiceRegistry;

public class NestedRootBuildRunner {
    public static StartParameter createStartParameterForNewBuild(ServiceRegistry services) {
        return ((StartParameter)services.get(StartParameter.class)).newBuild();
    }

    public static void runNestedRootBuild(String buildName, StartParameterInternal startParameter, ServiceRegistry services) {
        NestedRootBuildRunner.createNestedBuildTree(buildName, startParameter, services).run(buildController -> {
            buildController.scheduleAndRunTasks();
            return null;
        });
    }

    public static NestedBuildTree createNestedBuildTree(@Nullable String buildName, StartParameterInternal startParameter, ServiceRegistry services) {
        PublicBuildPath fromBuild = (PublicBuildPath)services.get(PublicBuildPath.class);
        BuildDefinition buildDefinition = BuildDefinition.fromStartParameter(startParameter, fromBuild);
        BuildState currentBuild = (BuildState)services.get(BuildState.class);
        BuildStateRegistry buildStateRegistry = (BuildStateRegistry)services.get(BuildStateRegistry.class);
        return buildStateRegistry.addNestedBuildTree(buildDefinition, currentBuild, buildName);
    }
}

