/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dgm.DGMFileType;
import org.jetbrains.plugins.groovy.dgm.GroovyAsyncMacroModuleListener;
import org.jetbrains.plugins.groovy.dgm.GroovyMacroRegistryServiceImplKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.transformations.macro.GroovyMacroRegistryService;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fJ\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR,\u0010\r\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/groovy/dgm/GroovyMacroRegistryServiceImpl;", "Lorg/jetbrains/plugins/groovy/transformations/macro/GroovyMacroRegistryService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "availableModules", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/util/CachedValue;", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiMethod;", "resolveAsMacro", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "getAllKnownMacros", "", "context", "Lcom/intellij/psi/PsiElement;", "refreshModule", "", "module", "getModuleRegistry", "dispose", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nGroovyMacroRegistryServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyMacroRegistryServiceImpl.kt\norg/jetbrains/plugins/groovy/dgm/GroovyMacroRegistryServiceImpl\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,99:1\n19#2:100\n19#2:118\n774#3:101\n865#3,2:102\n1611#3,9:105\n1863#3:114\n1864#3:116\n1620#3:117\n1628#3,3:122\n1#4:104\n1#4:115\n3829#5:119\n4344#5,2:120\n37#6,2:125\n*S KotlinDebug\n*F\n+ 1 GroovyMacroRegistryServiceImpl.kt\norg/jetbrains/plugins/groovy/dgm/GroovyMacroRegistryServiceImpl\n*L\n37#1:100\n63#1:118\n38#1:101\n38#1:102,2\n44#1:105,9\n44#1:114\n44#1:116\n44#1:117\n74#1:122,3\n44#1:115\n67#1:119\n67#1:120,2\n74#1:125,2\n*E\n"})
public final class GroovyMacroRegistryServiceImpl
implements GroovyMacroRegistryService,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Map<Module, CachedValue<Set<SmartPsiElementPointer<PsiMethod>>>> availableModules;

    public GroovyMacroRegistryServiceImpl(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.availableModules = new ConcurrentHashMap();
        new GroovyAsyncMacroModuleListener(this.project, this.cs).subscribe$intellij_groovy();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PsiMethod resolveAsMacro(@NotNull GrMethodCall call) {
        Object v6;
        block5: {
            void $this$filterTo$iv$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)call);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            GrExpression $this$asSafely$iv = call.getInvokedExpression();
            boolean $i$f$asSafely = false;
            GrExpression grExpression = $this$asSafely$iv;
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            if ((object = (GrReferenceExpression)grExpression) == null || (object = object.getReferenceName()) == null) {
                return null;
            }
            Object invokedName = object;
            Iterable $this$filter$iv = this.getModuleRegistry(module2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SmartPsiElementPointer it = (SmartPsiElementPointer)element$iv$iv;
                boolean bl = false;
                PsiMethod psiMethod = (PsiMethod)it.getElement();
                if (!Intrinsics.areEqual((Object)(psiMethod != null ? psiMethod.getName() : null), (Object)invokedName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidates = (List)destination$iv$iv;
            iterable = candidates;
            for (Object t : iterable) {
                SmartPsiElementPointer it = (SmartPsiElementPointer)t;
                boolean bl = false;
                PsiMethod psiMethod = (PsiMethod)it.getElement();
                boolean bl2 = psiMethod != null ? GroovyMacroRegistryServiceImplKt.access$canBeAppliedTo(psiMethod, call) : false;
                if (!bl2) continue;
                v6 = t;
                break block5;
            }
            v6 = null;
        }
        SmartPsiElementPointer smartPsiElementPointer = v6;
        return smartPsiElementPointer != null ? (PsiMethod)smartPsiElementPointer.getElement() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PsiMethod> getAllKnownMacros(@NotNull PsiElement context) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        Iterable $this$mapNotNull$iv = this.getModuleRegistry(module2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiMethod it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SmartPsiElementPointer it = (SmartPsiElementPointer)element$iv$iv;
            boolean bl2 = false;
            if ((PsiMethod)it.getElement() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void refreshModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.availableModules.remove(module);
    }

    private final Set<SmartPsiElementPointer<PsiMethod>> getModuleRegistry(Module module) {
        Object object = this.availableModules.computeIfAbsent(module, arg_0 -> GroovyMacroRegistryServiceImpl.getModuleRegistry$lambda$7(arg_0 -> GroovyMacroRegistryServiceImpl.getModuleRegistry$lambda$6(module, arg_0), arg_0)).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Set)object;
    }

    public void dispose() {
        this.availableModules.clear();
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getModuleRegistry$lambda$6$lambda$5(Module $module) {
        void $this$mapTo$iv;
        PsiMethod extensionClass;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)$module);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)DGMFileType.INSTANCE), (GlobalSearchScope)scope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        Collection extensionFiles = collection;
        if (extensionFiles.isEmpty()) {
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return new CachedValueProvider.Result((Object)SetsKt.emptySet(), objectArray);
        }
        Set macroRegistry = new LinkedHashSet();
        List extensionClassFiles = new ArrayList();
        for (VirtualFile extensionVirtualFile : extensionFiles) {
            void $this$filterTo$iv$iv;
            PsiFile psi;
            Intrinsics.checkNotNullExpressionValue((Object)PsiUtilBase.getPsiFile((Project)$module.getProject(), (VirtualFile)extensionVirtualFile), (String)"getPsiFile(...)");
            PsiFile $this$asSafely$iv = psi;
            boolean $i$f$asSafely = false;
            PsiFile psiFile = $this$asSafely$iv;
            if (!(psiFile instanceof PropertiesFile)) {
                psiFile = null;
            }
            PropertiesFile propertiesFile = (PropertiesFile)psiFile;
            Object inst = propertiesFile != null ? propertiesFile.findPropertyByKey("extensionClasses") : null;
            Object object = inst;
            if (object == null || (object = object.getValue()) == null) continue;
            Object extensionClassName = object;
            if (JavaPsiFacade.getInstance((Project)$module.getProject()).findClass((String)extensionClassName, scope) == null) continue;
            UtilKt.addIfNotNull((List)extensionClassFiles, (Object)extensionClass.getContainingFile().getVirtualFile());
            PsiMethod[] psiMethodArray = extensionClass.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = psiMethodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl = false;
                if (!(it.hasAnnotation("org.codehaus.groovy.macro.runtime.Macro") && it.getParameterList().getParameters()[0].getTypeElement() != null && it.getParameterList().getParameters()[0].getType().equalsToText("org.codehaus.groovy.macro.runtime.MacroContext"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List macroMethods = (List)destination$iv$iv;
            macroRegistry.addAll(macroMethods);
        }
        Object object = macroRegistry;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            extensionClass = (PsiMethod)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(SmartPointerManager.createPointer((PsiElement)((PsiElement)it)));
        }
        object = new SpreadBuilder(2);
        Collection $this$toTypedArray$iv = extensionFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new VirtualFile[0]));
        $this$toTypedArray$iv = extensionClassFiles;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new VirtualFile[0]));
        Object[] objectArray = object.toArray(new Object[object.size()]);
        Collection collection3 = destination$iv;
        return new CachedValueProvider.Result((Object)collection3, objectArray);
    }

    private static final CachedValue getModuleRegistry$lambda$6(Module $module, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CachedValue cachedValue = CachedValuesManager.getManager((Project)$module.getProject()).createCachedValue(() -> GroovyMacroRegistryServiceImpl.getModuleRegistry$lambda$6$lambda$5($module));
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"createCachedValue(...)");
        CachedValue moduleRegistry = cachedValue;
        return moduleRegistry;
    }

    private static final CachedValue getModuleRegistry$lambda$7(Function1 $tmp0, Object p0) {
        return (CachedValue)$tmp0.invoke(p0);
    }
}

