/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.DomFileElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenAdditionalHightligher;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPsiReference;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModulePsiReference
extends MavenPsiReference
implements LocalQuickFixProvider {
    public MavenModulePsiReference(PsiElement element, String text, TextRange range) {
        super(element, text, range);
    }

    public PsiElement resolve() {
        PsiFile result2;
        VirtualFile baseDir = this.myPsiFile.getVirtualFile().getParent();
        if (baseDir == null) {
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)this.myText);
        VirtualFile file = baseDir.findFileByRelativePath(path);
        if (file == null || file.isDirectory()) {
            String relPath = FileUtil.toSystemIndependentName((String)(path + "/pom.xml"));
            file = baseDir.findFileByRelativePath(relPath);
        }
        if (file == null && (result2 = (PsiFile)MavenAdditionalHightligher.EP.getExtensionList().stream().map(e -> e.resolveModulePsi(this.myText, this.myPsiFile, this.myVirtualFile)).filter(it -> it != null).findFirst().orElse(null)) != null) {
            return result2;
        }
        if (file == null) {
            return null;
        }
        return this.getPsiFile(file);
    }

    public Object @NotNull [] getVariants() {
        List<DomFileElement<MavenDomProjectModel>> files2 = MavenDomUtil.collectProjectModels(this.getProject());
        ArrayList<LookupElementBuilder> result2 = new ArrayList<LookupElementBuilder>();
        for (DomFileElement<MavenDomProjectModel> eachDomFile : files2) {
            VirtualFile eachVFile = eachDomFile.getOriginalFile().getVirtualFile();
            if (Comparing.equal((Object)eachVFile, (Object)this.myVirtualFile)) continue;
            XmlFile psiFile = eachDomFile.getFile();
            String modulePath = MavenModulePsiReference.calcRelativeModulePath(this.myVirtualFile, eachVFile);
            result2.add(LookupElementBuilder.create((Object)psiFile, (String)modulePath).withPresentableText(modulePath));
        }
        Object[] objectArray = result2.toArray();
        if (objectArray == null) {
            MavenModulePsiReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public static String calcRelativeModulePath(VirtualFile parentPom, VirtualFile modulePom) {
        String result2 = MavenDomUtil.calcRelativePath(parentPom.getParent(), modulePom);
        if (!result2.endsWith("/pom.xml")) {
            return result2;
        }
        int to = result2.length() - "/pom.xml".length();
        return result2.substring(0, to);
    }

    private PsiFile getPsiFile(VirtualFile file) {
        return PsiManager.getInstance((Project)this.getProject()).findFile(file);
    }

    private Project getProject() {
        return this.myPsiFile.getProject();
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        if (this.myText.length() == 0 || this.resolve() != null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new CreateModuleFix(true, this.myText, this.myPsiFile), new CreateModuleFix(false, this.myText, this.myPsiFile)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenModulePsiReference", "getVariants"));
    }

    private static final class CreateModuleFix
    extends LocalQuickFixOnPsiElement {
        private final boolean myWithParent;
        private final String myModulePath;

        private CreateModuleFix(boolean withParent, String modulePath, PsiFile psiFile) {
            super((PsiElement)psiFile);
            this.myWithParent = withParent;
            this.myModulePath = modulePath;
        }

        @NotNull
        public String getText() {
            String string = this.myWithParent ? MavenDomBundle.message("fix.create.module.with.parent", new Object[0]) : MavenDomBundle.message("fix.create.module", new Object[0]);
            if (string == null) {
                CreateModuleFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                CreateModuleFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                CreateModuleFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                CreateModuleFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                CreateModuleFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                CreateModuleFix.$$$reportNull$$$0(5);
            }
            try {
                PsiFile psiFile = (PsiFile)startElement;
                VirtualFile modulePom = this.createModulePom(psiFile.getVirtualFile());
                MavenId id = MavenDomUtil.describe(psiFile);
                String groupId = id.getGroupId() == null ? "groupId" : id.getGroupId();
                String artifactId = modulePom.getParent().getName();
                String version = id.getVersion() == null ? "version" : id.getVersion();
                MavenUtil.runOrApplyMavenProjectFileTemplate(project, modulePom, new MavenId(groupId, artifactId, version), (MavenId)(this.myWithParent ? id : null), psiFile.getVirtualFile(), true);
            }
            catch (IOException e) {
                MavenUtil.showError(project, MavenProjectBundle.message("notification.title.cannot.create.module", new Object[0]), e);
            }
        }

        private VirtualFile createModulePom(VirtualFile virtualFile) throws IOException {
            String fileName;
            VirtualFile baseDir = virtualFile.getParent();
            String modulePath = FileUtil.toCanonicalPath((String)(baseDir.getPath() + "/" + this.myModulePath));
            String pomFileName = "pom.xml";
            if (!new File(FileUtil.toSystemDependentName((String)modulePath)).isDirectory() && (MavenUtil.isPomFileName(fileName = PathUtil.getFileName((String)modulePath)) || MavenUtil.isPotentialPomFile(fileName))) {
                modulePath = PathUtil.getParentPath((String)modulePath);
                pomFileName = fileName;
            }
            VirtualFile moduleDir = VfsUtil.createDirectories((String)modulePath);
            return moduleDir.createChildData((Object)this, pomFileName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenModulePsiReference$CreateModuleFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenModulePsiReference$CreateModuleFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

