/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;

abstract class GroupNode
extends MavenSimpleNode {
    private static final Comparator<MavenSimpleNode> NODE_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);

    GroupNode(MavenProjectsStructure structure, MavenSimpleNode parent) {
        super(structure, parent);
    }

    @Override
    public boolean isVisible() {
        if (this.getDisplayKind() == MavenProjectsStructure.DisplayKind.ALWAYS) {
            return true;
        }
        for (SimpleNode each : this.getChildren()) {
            if (!((MavenSimpleNode)each).isVisible()) continue;
            return true;
        }
        return false;
    }

    protected <T extends MavenSimpleNode> void insertSorted(List<T> list, T newObject) {
        int pos = Collections.binarySearch(list, newObject, NODE_COMPARATOR);
        list.add(pos >= 0 ? pos : -pos - 1, newObject);
    }

    protected void sort(List<? extends MavenSimpleNode> list) {
        list.sort(NODE_COMPARATOR);
    }
}

