/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DADependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAOmitted;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAScope;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAWarning;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\r2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "whenDataChanged", "", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getProjects", "", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "getDependencyScopes", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "externalProject", "getDependencies", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "createDependencyList", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "collectDependency", "nodes", "Lorg/jetbrains/idea/maven/model/MavenArtifactNode;", "parentDependency", "result", "", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "mavenArtifactNode", "getStatus", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Status;", "Companion", "intellij.maven"})
public final class MavenDependencyAnalyzerContributor
implements DependencyAnalyzerContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<MavenId> MAVEN_ARTIFACT_ID;

    public MavenDependencyAnalyzerContributor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void whenDataChanged(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        projectsManager.addProjectsTreeListener(new MavenProjectsTree.Listener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @NotNull
    public List<DependencyAnalyzerProject> getProjects() {
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
        ArrayList<DAProject> externalProjects = new ArrayList<DAProject>();
        for (MavenProject mavenProject : mavenProjectsManager.getProjects()) {
            Module module;
            if ((Module)ActionsKt.runReadAction(() -> MavenDependencyAnalyzerContributor.getProjects$lambda$0(mavenProjectsManager, mavenProject)) == null) continue;
            externalProjects.add(new DAProject(module, mavenProject.getDisplayName()));
        }
        return externalProjects;
    }

    @NotNull
    public List<DependencyAnalyzerDependency.Scope> getDependencyScopes(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Object[] objectArray = new DAScope[]{Companion.scope("compile"), Companion.scope("provided"), Companion.scope("runtime"), Companion.scope("system"), Companion.scope("import"), Companion.scope("test")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<DependencyAnalyzerDependency> getDependencies(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        MavenProject mavenProject = projectsManager.findProject(externalProject.getModule());
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject mavenProject2 = mavenProject;
        return this.createDependencyList(mavenProject2);
    }

    private final List<DependencyAnalyzerDependency> createDependencyList(MavenProject mavenProject) {
        DAModule root = new DAModule(mavenProject.getDisplayName());
        MavenId mavenId = mavenProject.getMavenId();
        root.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion()));
        DADependency rootDependency = new DADependency((DependencyAnalyzerDependency.Data)root, (DependencyAnalyzerDependency.Scope)Companion.scope("compile"), null, CollectionsKt.emptyList());
        List result2 = new ArrayList();
        this.collectDependency(mavenProject.getDependencyTree(), (DependencyAnalyzerDependency)rootDependency, result2);
        return result2;
    }

    private final void collectDependency(List<? extends MavenArtifactNode> nodes, DependencyAnalyzerDependency parentDependency, List<DependencyAnalyzerDependency> result2) {
        for (MavenArtifactNode mavenArtifactNode : nodes) {
            DependencyAnalyzerDependency.Data data = this.getDependencyData(mavenArtifactNode);
            String string = mavenArtifactNode.getOriginalScope();
            if (string == null) {
                string = "compile";
            }
            DADependency dependency = new DADependency(data, (DependencyAnalyzerDependency.Scope)Companion.scope(string), parentDependency, this.getStatus(mavenArtifactNode));
            result2.add((DependencyAnalyzerDependency)dependency);
            if (mavenArtifactNode.getDependencies() == null) continue;
            List list = mavenArtifactNode.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
            this.collectDependency(list, (DependencyAnalyzerDependency)dependency, result2);
        }
    }

    private final DependencyAnalyzerDependency.Data getDependencyData(MavenArtifactNode mavenArtifactNode) {
        MavenProject mavenProject = MavenProjectsManager.getInstance(this.project).findProject(mavenArtifactNode.getArtifact());
        String string = mavenArtifactNode.getArtifact().getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroupId(...)");
        String string2 = mavenArtifactNode.getArtifact().getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
        String string3 = mavenArtifactNode.getArtifact().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
        DAArtifact daArtifact = new DAArtifact(string, string2, string3);
        if (mavenProject != null) {
            DAModule daModule = new DAModule(mavenProject.getDisplayName());
            daModule.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(daArtifact.getGroupId(), daArtifact.getArtifactId(), daArtifact.getVersion()));
            return (DependencyAnalyzerDependency.Data)daModule;
        }
        return (DependencyAnalyzerDependency.Data)daArtifact;
    }

    private final List<DependencyAnalyzerDependency.Status> getStatus(MavenArtifactNode mavenArtifactNode) {
        List status = new ArrayList();
        if (mavenArtifactNode.getState() == MavenArtifactState.CONFLICT) {
            status.add(DAOmitted.INSTANCE);
            Object object = mavenArtifactNode.getRelatedArtifact();
            if (object != null && (object = object.getVersion()) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict", (Object[])objectArray);
                Intrinsics.checkNotNull((Object)message);
                status.add(new DAWarning(message));
            }
        } else if (mavenArtifactNode.getState() == MavenArtifactState.DUPLICATE) {
            status.add(DAOmitted.INSTANCE);
        }
        if (!mavenArtifactNode.getArtifact().isResolvedArtifact()) {
            String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            status.add(new DAWarning(string));
        }
        return status;
    }

    private static final Module getProjects$lambda$0(MavenProjectsManager $mavenProjectsManager, MavenProject $mavenProject) {
        return $mavenProjectsManager.findModule($mavenProject);
    }

    static {
        Key key = Key.create((String)"MavenDependencyAnalyzerContributor.MavenId");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MAVEN_ARTIFACT_ID = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bR$\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor$Companion;", "", "<init>", "()V", "scope", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "MAVEN_ARTIFACT_ID", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/model/MavenId;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMAVEN_ARTIFACT_ID", "()Lcom/intellij/openapi/util/Key;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DAScope scope(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = StringUtil.toTitleCase((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toTitleCase(...)");
            return new DAScope(name, string);
        }

        @NotNull
        public final Key<MavenId> getMAVEN_ARTIFACT_ID() {
            return MAVEN_ARTIFACT_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

