/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.python;

import com.intellij.codeInsight.template.Template;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionStringLiteralSupporter;
import com.intellij.ml.inline.completion.impl.kit.Quote;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.FilteredTraverserBase;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/inline/completion/python/PythonStringLiteralSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionStringLiteralSupporter;", "<init>", "()V", "isStringElement", "", "element", "Lcom/intellij/psi/PsiElement;", "isStringWalkingEnabled", "getQuote", "Lcom/intellij/ml/inline/completion/impl/kit/Quote;", "offset", "", "getMulticharQuotes", "", "", "createStringTemplate", "Lcom/intellij/codeInsight/template/Template;", "range", "Lcom/intellij/openapi/util/TextRange;", "intellij.ml.inline.completion.python"})
@SourceDebugExtension(value={"SMAP\nPythonStringLiteralSupporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonStringLiteralSupporter.kt\ncom/intellij/ml/inline/completion/python/PythonStringLiteralSupporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1577#2,11:71\n1872#2,2:82\n1874#2:85\n1588#2:86\n1#3:84\n*S KotlinDebug\n*F\n+ 1 PythonStringLiteralSupporter.kt\ncom/intellij/ml/inline/completion/python/PythonStringLiteralSupporter\n*L\n49#1:71,11\n49#1:82,2\n49#1:85\n49#1:86\n49#1:84\n*E\n"})
public final class PythonStringLiteralSupporter
extends MLCompletionStringLiteralSupporter {
    @Override
    public boolean isStringElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PyStringElement || element instanceof PyStringLiteralExpression || element.getParent() instanceof PyFormattedStringElement;
    }

    @Override
    public boolean isStringWalkingEnabled(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        return psiElement instanceof PyStringElement ? !((PyStringElement)element).isTripleQuoted() : (psiElement instanceof PyStringLiteralExpression ? !((PyStringLiteralExpression)element).isDocString() : true);
    }

    @Override
    @Nullable
    public Quote getQuote(@NotNull PsiElement element, int offset) {
        Quote quote;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyStringElement pyStringElement = element instanceof PyStringElement ? (PyStringElement)element : null;
        if (pyStringElement == null) {
            return null;
        }
        PyStringElement stringElement = pyStringElement;
        String string = stringElement.getQuote();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuote(...)");
        Quote it = quote = new Quote(string);
        boolean bl = false;
        return PsiTreeUtilKt.getStartOffset((PsiElement)element) != offset && (!stringElement.isTerminated() || offset != PsiTreeUtilKt.getEndOffset((PsiElement)element)) ? quote : null;
    }

    @Override
    @NotNull
    public Set<String> getMulticharQuotes() {
        Object[] objectArray = new String[]{"'''", "\"\"\""};
        return SetsKt.setOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Template createStringTemplate(@NotNull PsiElement element, @NotNull TextRange range) {
        void $this$mapIndexedNotNullTo$iv$iv;
        void $this$mapIndexedNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String content = null;
        String string = range.substring(element.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        content = string;
        int contentOffset = 0;
        FilteredTraverserBase filteredTraverserBase = ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)element)).onRange(range).filter(arg_0 -> PythonStringLiteralSupporter.createStringTemplate$lambda$2(PythonStringLiteralSupporter::createStringTemplate$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"filter(...)");
        Iterable iterable = (Iterable)filteredTraverserBase;
        boolean $i$f$mapIndexedNotNull = false;
        void var7_8 = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            String string2;
            void it;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            PsiElement psiElement = (PsiElement)element$iv$iv;
            int id = index$iv$iv;
            boolean bl2 = false;
            if (!range.contains(it.getTextRange())) {
                return null;
            }
            if (it instanceof PyStringElement && !((PyStringElement)it).isTripleQuoted()) {
                TextRange contentRange;
                Intrinsics.checkNotNullExpressionValue((Object)((PyStringElement)it).getContentRange().shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)it) - range.getStartOffset() + contentOffset), (String)"shiftRight(...)");
                String name = "$__Variable" + id + "$";
                contentOffset += name.length() - contentRange.getLength();
                content = contentRange.replace(content, name);
                string2 = ((PyStringElement)it).getContent();
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            String it$iv$iv = string2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        return this.createTemplate(content, it);
    }

    private static final boolean createStringTemplate$lambda$1(PsiElement it) {
        return it instanceof PyStringElement;
    }

    private static final boolean createStringTemplate$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

