/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 !2\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0003\u001f !B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u0010*\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0010*\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001d\u001a\u00020\u0010*\u00020\u001eH\u0002\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isRelatedToParameter", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "isNotFinalReadOnly", "primaryConstructorProperty", "isInapplicableParameterType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isSubtypeOfCloneable", "isCloneableId", "Lorg/jetbrains/kotlin/name/ClassId;", "Regular", "ForExpectClass", "Companion", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 10 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n*L\n1#1,326:1\n35#2:327\n51#2:328\n11#2:329\n35#2:342\n72#3:330\n14#3:363\n34#4:331\n1202#5,2:332\n1230#5,4:334\n1863#5,2:344\n1755#5,3:349\n126#6:338\n153#6,3:339\n39#7:343\n39#7:359\n12567#8,2:346\n1#9:348\n165#10:352\n122#10,4:353\n103#10:357\n91#10:358\n97#10:360\n126#10,2:361\n*S KotlinDebug\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker\n*L\n62#1:327\n62#1:328\n66#1:329\n112#1:342\n77#1:330\n166#1:363\n77#1:331\n97#1:332,2\n97#1:334,4\n256#1:344,2\n316#1:349,3\n99#1:338\n99#1:339,3\n118#1:343\n165#1:359\n274#1:346,2\n165#1:352\n165#1:353,4\n165#1:357\n165#1:358\n165#1:360\n165#1:361,2\n*E\n"})
public abstract class FirValueClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> boxAndUnboxNames;
    @NotNull
    private static final Set<String> equalsAndHashCodeNames;
    @NotNull
    private static final FqName javaLangFqName;
    @NotNull
    private static final FqName cloneableFqName;

    private FirValueClassDeclarationChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        block43: {
            block42: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (!DeclarationUtilsKt.isInlineOrValueClass(declaration.getSymbol())) {
                    return;
                }
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block42;
                FirClassLikeDeclaration $this$isLocal$iv = declaration;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block43;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_NOT_TOP_LEVEL(), (DiagnosticContext)context2, null, (int)8, null);
        }
        FirMemberDeclaration $this$modality$iv = declaration;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_NOT_FINAL(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (!((Collection)declaration.getContextReceivers()).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_HAVE_CONTEXT_RECEIVERS(), (DiagnosticContext)context2, null, (int)8, null);
        }
        for (FirTypeRef supertypeEntry : declaration.getSuperTypeRefs()) {
            boolean bl;
            if (supertypeEntry instanceof FirImplicitAnyTypeRef || supertypeEntry instanceof FirErrorTypeRef) continue;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(supertypeEntry, context2.getSession());
            if (firRegularClassSymbol != null) {
                FirClassSymbol $this$isInterface$iv = firRegularClassSymbol;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            } else {
                bl = false;
            }
            if (bl) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)supertypeEntry.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_EXTEND_CLASSES(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (this.isSubtypeOfCloneable(declaration, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), (DiagnosticContext)context2, null, (int)8, null);
        }
        FirConstructor primaryConstructor = null;
        Map primaryConstructorParametersByName = MapsKt.emptyMap();
        Map primaryConstructorPropertiesByName = new LinkedHashMap();
        Set primaryConstructorParametersSymbolsSet = SetsKt.emptySet();
        boolean isCustomEqualsSupported = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.CustomEqualsInValueClasses);
        for (FirDeclaration innerDeclaration : declaration.getDeclarations()) {
            object = innerDeclaration;
            if (object instanceof FirConstructor) {
                FirBlock firBlock;
                if (((FirConstructor)innerDeclaration).isPrimary()) {
                    void $this$mapTo$iv$iv;
                    Object object2;
                    void $this$associateByTo$iv$iv;
                    primaryConstructor = (FirConstructor)innerDeclaration;
                    Iterable iterable = ((FirConstructor)innerDeclaration).getValueParameters();
                    boolean $i$f$associateBy = false;
                    int capacity$iv232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
                    Iterable iterable2 = iterable;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv232);
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                        void it;
                        FirValueParameter firValueParameter = (FirValueParameter)element$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl = false;
                        object2.put(it.getName(), element$iv$iv);
                    }
                    Map map = primaryConstructorParametersByName = destination$iv$iv;
                    boolean $i$f$map = false;
                    Map capacity$iv232 = map;
                    Collection destination$iv$iv2 = new ArrayList(map.size());
                    boolean $i$f$mapTo = false;
                    for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                        Object element$iv$iv;
                        element$iv$iv = item$iv$iv;
                        object2 = destination$iv$iv2;
                        boolean bl = false;
                        FirValueParameter parameter = (FirValueParameter)element$iv$iv.getValue();
                        object2.add(parameter.getSymbol());
                    }
                    primaryConstructorParametersSymbolsSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    continue;
                }
                if (((FirConstructor)innerDeclaration).getBody() == null || context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClassesSecondaryConstructorWithBody)) continue;
                Intrinsics.checkNotNull((Object)((FirConstructor)innerDeclaration).getBody());
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)firBlock.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, (int)8, null);
                continue;
            }
            if (object instanceof FirRegularClass) {
                FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)innerDeclaration;
                boolean $i$f$isInner = false;
                if (!firMemberDeclaration.getStatus().isInner()) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirRegularClass)innerDeclaration).getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINNER_CLASS_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, (int)8, null);
                continue;
            }
            if (object instanceof FirField) {
                FirCallableSymbol<?> firCallableSymbol;
                FirDeclaration firDeclaration = innerDeclaration;
                boolean $i$f$isSynthetic = false;
                if (!(firDeclaration.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
                FirExpression firExpression = ((FirField)innerDeclaration).getInitializer();
                FirCallableSymbol<?> firCallableSymbol2 = firCallableSymbol = firExpression != null ? ReferenceUtilsKt.toResolvedCallableSymbol(firExpression, context2.getSession()) : null;
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && firCallableSymbol != null && CollectionsKt.contains((Iterable)primaryConstructorParametersSymbolsSet, firCallableSymbol)) continue;
                FirTypeRef firTypeRef = ((FirField)innerDeclaration).getReturnTypeRef();
                Intrinsics.checkNotNull((Object)firTypeRef, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
                FirTypeRef firTypeRef2 = ((FirResolvedTypeRef)firTypeRef).getDelegatedTypeRef();
                KtSourceElement delegatedTypeRefSource = firTypeRef2 != null ? firTypeRef2.getSource() : null;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)delegatedTypeRefSource), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), (DiagnosticContext)context2, null, (int)8, null);
                continue;
            }
            if (!(object instanceof FirProperty)) continue;
            if (this.isRelatedToParameter((FirProperty)innerDeclaration, (FirValueParameter)primaryConstructorParametersByName.get(((FirProperty)innerDeclaration).getName()))) {
                primaryConstructorPropertiesByName.put(((FirProperty)innerDeclaration).getName(), innerDeclaration);
                continue;
            }
            if (((FirProperty)innerDeclaration).getDelegate() != null) {
                FirExpression firExpression = ((FirProperty)innerDeclaration).getDelegate();
                Intrinsics.checkNotNull((Object)firExpression);
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)firExpression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, (int)8, null);
                continue;
            }
            if (!DeclarationAttributesKt.getHasBackingField((FirProperty)innerDeclaration)) continue;
            KtSourceElement ktSourceElement = ((FirProperty)innerDeclaration).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirProperty)innerDeclaration).getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_VALUE_CLASS(), (DiagnosticContext)context2, null, (int)8, null);
        }
        Set reservedNames = SetsKt.plus(boxAndUnboxNames, (Iterable)(isCustomEqualsSupported ? SetsKt.emptySet() : equalsAndHashCodeNames));
        FirTypeScope classScope = FirHelpersKt.unsubstitutedScope(declaration, context2);
        for (String string : reservedNames) {
            Name name2 = Name.identifier((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            classScope.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirValueClassDeclarationChecker.check$lambda$2(declaration, reporter, string, context2, arg_0)));
        }
        FirConstructor firConstructor = primaryConstructor;
        if (!((firConstructor != null && (firConstructor = firConstructor.getSource()) != null ? firConstructor.getKind() : null) instanceof KtRealSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS(), (DiagnosticContext)context2, null, (int)8, null);
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
            if (primaryConstructorParametersByName.isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)primaryConstructor.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_EMPTY_CONSTRUCTOR(), (DiagnosticContext)context2, null, (int)8, null);
                return;
            }
        } else if (primaryConstructorParametersByName.size() != 1) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)primaryConstructor.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), (DiagnosticContext)context2, null, (int)8, null);
            return;
        }
        for (Map.Entry entry : primaryConstructorParametersByName.entrySet()) {
            Name name3 = (Name)entry.getKey();
            FirValueParameter primaryConstructorParameter = (FirValueParameter)entry.getValue();
            if (this.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorPropertiesByName.get(name3))) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)primaryConstructorParameter.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), (DiagnosticContext)context2, null, (int)8, null);
                continue;
            }
            if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter)) {
                ConeKotlinType it = FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef());
                boolean bl = false;
                boolean bl2 = it instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(it);
                if (bl2) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource()), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)LanguageFeature.GenericInlineClassParameter, (Object)context2.getLanguageVersionSettings()), (DiagnosticContext)context2, null, (int)16, null);
                    continue;
                }
            }
            if (this.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef(), context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource()), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), (DiagnosticContext)context2, null, (int)16, null);
                continue;
            }
            if (FirHelpersKt.isRecursiveValueClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)primaryConstructorParameter.getReturnTypeRef().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), (DiagnosticContext)context2, null, (int)8, null);
                continue;
            }
            if (FirValueClassRepresentationKt.getMultiFieldValueClassRepresentation(declaration) == null || primaryConstructorParameter.getDefaultValue() == null) continue;
            FirExpression firExpression = primaryConstructorParameter.getDefaultValue();
            Intrinsics.checkNotNull((Object)firExpression);
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)firExpression.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getMULTI_FIELD_VALUE_CLASS_PRIMARY_CONSTRUCTOR_DEFAULT_PARAMETER(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (isCustomEqualsSupported) {
            FirValueClassDeclarationChecker $this$check_u24lambda_u245 = this;
            boolean bl = false;
            FirDeclaration equalsFromAnyOverriding = null;
            FirDeclaration typedEquals = null;
            Iterable $this$forEach$iv = declaration.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl3 = false;
                if (!(it instanceof FirSimpleFunction)) continue;
                if (DeclarationUtilsKt.isEquals((FirSimpleFunction)it, context2.getSession())) {
                    equalsFromAnyOverriding = it;
                }
                if (!ValueClassesUtilsKt.isTypedEqualsInValueClass((FirSimpleFunction)it, context2.getSession())) continue;
                typedEquals = it;
            }
            object = TuplesKt.to(equalsFromAnyOverriding, typedEquals);
            FirSimpleFunction firSimpleFunction = (FirSimpleFunction)object.component1();
            FirSimpleFunction typedEquals2 = (FirSimpleFunction)object.component2();
            if (typedEquals2 != null) {
                boolean bl3;
                FirTypeRef singleParameterReturnTypeRef;
                block41: {
                    if (!((Collection)typedEquals2.getTypeParameters()).isEmpty()) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)typedEquals2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getTYPE_PARAMETERS_NOT_ALLOWED(), (DiagnosticContext)context2, null, (int)8, null);
                    }
                    singleParameterReturnTypeRef = ((FirValueParameter)CollectionsKt.single(typedEquals2.getValueParameters())).getReturnTypeRef();
                    ConeTypeProjection[] $this$any$iv = FirTypeUtilsKt.getConeType(singleParameterReturnTypeRef).getTypeArguments();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        ConeTypeProjection element$iv;
                        ConeTypeProjection it = element$iv = $this$any$iv[j];
                        boolean bl5 = false;
                        if (!(!ConeTypeProjectionKt.isStarProjection(it))) continue;
                        bl3 = true;
                        break block41;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)singleParameterReturnTypeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getTYPE_ARGUMENT_ON_TYPED_VALUE_CLASS_EQUALS(), (DiagnosticContext)context2, null, (int)8, null);
                }
            }
            if (firSimpleFunction != null && typedEquals2 == null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)firSimpleFunction.getSource()), FirErrors.INSTANCE.getINEFFICIENT_EQUALS_OVERRIDING_IN_VALUE_CLASS(), (Object)ConeTypeUtilsKt.replaceArgumentsWithStarProjections(ScopeUtilsKt.defaultType(declaration)), (DiagnosticContext)context2, null, (int)16, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelatedToParameter(FirProperty $this$isRelatedToParameter, FirValueParameter parameter) {
        FirValueParameter firValueParameter = parameter;
        if (!Intrinsics.areEqual((Object)$this$isRelatedToParameter.getName(), (Object)(firValueParameter != null ? firValueParameter.getName() : null))) return false;
        KtSourceElement ktSourceElement = $this$isRelatedToParameter.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) return false;
        return true;
    }

    private final boolean isNotFinalReadOnly(FirValueParameter $this$isNotFinalReadOnly, FirProperty primaryConstructorProperty) {
        if (primaryConstructorProperty == null) {
            return true;
        }
        FirElement firElement = $this$isNotFinalReadOnly;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OPEN_KEYWORD");
        boolean isOpen = FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken);
        return $this$isNotFinalReadOnly.isVararg() || !primaryConstructorProperty.isVal() || isOpen;
    }

    private final boolean isInapplicableParameterType(FirTypeRef $this$isInapplicableParameterType, FirSession session) {
        ConeKotlinType it = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType($this$isInapplicableParameterType), session, null, 2, null);
        boolean bl = false;
        return ConeBuiltinTypeUtilsKt.isUnit(it) || ConeBuiltinTypeUtilsKt.isNothing(it);
    }

    private final boolean isGenericArrayOfTypeParameter(ConeKotlinType $this$isGenericArrayOfTypeParameter) {
        if (ArraysKt.firstOrNull((Object[])$this$isGenericArrayOfTypeParameter.getTypeArguments()) instanceof ConeStarProjection || !ArrayUtilsKt.isPotentiallyArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default($this$isGenericArrayOfTypeParameter, false, 1, null);
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType arrayElementType = coneKotlinType;
        return arrayElementType instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(arrayElementType);
    }

    private final boolean isSubtypeOfCloneable(FirRegularClass $this$isSubtypeOfCloneable, FirSession session) {
        boolean bl;
        block4: {
            if (this.isCloneableId(FirDeclarationUtilKt.getClassId($this$isSubtypeOfCloneable))) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubtypeOfCloneable, true, true, session, false, null, 32, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType superType = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!this.isCloneableId(TypeExpansionUtilsKt.fullyExpandedType$default(superType, session, null, 2, null).getLookupTag().getClassId())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCloneableId(ClassId $this$isCloneableId) {
        return Intrinsics.areEqual((Object)$this$isCloneableId.getRelativeClassName(), (Object)cloneableFqName) && (Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)javaLangFqName));
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit check$lambda$2(FirRegularClass $declaration, DiagnosticReporter $reporter, String $reservedName, CheckerContext $context, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$unwrapFakeOverrides$iv = it;
        $i$f$unwrapFakeOverrides = false;
        $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
        $i$f$unwrapFakeOverrides = false;
        current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
        while (true) {
            $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
            $i$f$originalIfFakeOverride = false;
            $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
            } else {
                v0 = v1 = null;
            }
            if (v0 == null) {
                $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getBaseForIntersectionOverride = false;
                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
            }
            if (v1 == null) break;
            current$iv$iv = next$iv$iv = v1;
        }
        v2 = current$iv$iv.getSymbol();
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
        }
        functionSymbol = (FirNamedFunctionSymbol)((FirCallableSymbol)((FirNamedFunctionSymbol)v2));
        $this$isAbstract$iv = functionSymbol;
        $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) {
            return Unit.INSTANCE;
        }
        v3 = FirHelpersKt.getContainingClassSymbol(functionSymbol);
        if (v3 == null) {
            return Unit.INSTANCE;
        }
        containingClassSymbol = v3;
        if (Intrinsics.areEqual(containingClassSymbol, (Object)$declaration.getSymbol())) {
            v4 = functionSymbol.getSource();
            if ((v4 != null ? v4.getKind() : null) instanceof KtRealSourceElementKind) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)functionSymbol.getSource()), FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_VALUE_CLASS(), (Object)$reservedName, (DiagnosticContext)$context, null, (int)16, null);
            }
        } else if (FirHelpersKt.getClassKind(containingClassSymbol) == ClassKind.INTERFACE) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$declaration.getSource()), FirErrors.INSTANCE.getRESERVED_MEMBER_FROM_INTERFACE_INSIDE_VALUE_CLASS(), (Object)containingClassSymbol.getName().asString(), (Object)$reservedName, (DiagnosticContext)$context, null, (int)32, null);
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ FirValueClassDeclarationChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    static {
        Object[] objectArray = new String[]{"box", "unbox"};
        boxAndUnboxNames = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"equals", "hashCode"};
        equalsAndHashCodeNames = SetsKt.setOf((Object[])objectArray);
        javaLangFqName = new FqName("java.lang");
        cloneableFqName = new FqName("Cloneable");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Companion;", "", "<init>", "()V", "boxAndUnboxNames", "", "", "equalsAndHashCodeNames", "javaLangFqName", "Lorg/jetbrains/kotlin/name/FqName;", "cloneableFqName", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,326:1\n34#2:327\n*S KotlinDebug\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass\n*L\n45#1:327\n*E\n"})
    public static final class ForExpectClass
    extends FirValueClassDeclarationChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context2, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,326:1\n34#2:327\n*S KotlinDebug\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular\n*L\n38#1:327\n*E\n"})
    public static final class Regular
    extends FirValueClassDeclarationChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context2, reporter);
        }
    }
}

