/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptAcceptedLocation;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptIdeConfigurationKt;
import kotlin.script.experimental.util.PropertiesCollection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBinaryExtensionKt;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindMatcher;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.script.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/RootKindMatcherImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/RootKindMatcher;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getFileIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileIndex$delegate", "Lkotlin/Lazy;", "matches", "", "filter", "Lorg/jetbrains/kotlin/idea/base/projectStructure/RootKindFilter;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "containsAllowedLocations", "", "Lkotlin/script/experimental/api/ScriptAcceptedLocation;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nRootKindMatcherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootKindMatcherImpl.kt\norg/jetbrains/kotlin/idea/base/analysis/RootKindMatcherImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1755#2,3:164\n*S KotlinDebug\n*F\n+ 1 RootKindMatcherImpl.kt\norg/jetbrains/kotlin/idea/base/analysis/RootKindMatcherImpl\n*L\n161#1:164,3\n*E\n"})
public final class RootKindMatcherImpl
implements RootKindMatcher {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy fileIndex$delegate;

    public RootKindMatcherImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fileIndex$delegate = LazyKt.lazy(() -> RootKindMatcherImpl.fileIndex_delegate$lambda$0(this));
    }

    private final ProjectFileIndex getFileIndex() {
        Lazy lazy = this.fileIndex$delegate;
        return (ProjectFileIndex)lazy.getValue();
    }

    @Override
    public boolean matches(@NotNull RootKindFilter filter2, @NotNull VirtualFile virtualFile) {
        RootKindFilter correctedFilter;
        List<ScriptAcceptedLocation> scriptScope;
        ScriptCompilationConfiguration scriptConfiguration;
        boolean hasBinaryFileExtension;
        boolean kotlinExcludeLibrarySources;
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ProgressManager.checkCanceled();
        boolean bl = kotlinExcludeLibrarySources = !filter2.getIncludeLibrarySourceFiles() && !filter2.getIncludeScriptsOutsideSourceRoots() && FileUtils.isKotlinFileType(virtualFile);
        if (kotlinExcludeLibrarySources && !filter2.getIncludeProjectSourceFiles()) {
            return false;
        }
        Set<Object> rootType = filter2.getIncludeResources() ? ProjectStructureUtils.getKOTLIN_AWARE_SOURCE_AND_RESOURCES_ROOT_TYPES() : ProjectStructureUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES();
        CharSequence charSequence = virtualFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence nameSequence = charSequence;
        boolean bl2 = hasBinaryFileExtension = StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".class", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kotlin_builtins", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kotlin_metadata", (boolean)false, (int)2, null);
        if (!(virtualFile instanceof VirtualFileWindow) && !hasBinaryFileExtension && this.getFileIndex().isUnderSourceRootOfType(virtualFile, rootType)) {
            return filter2.getIncludeProjectSourceFiles();
        }
        if (kotlinExcludeLibrarySources) {
            return false;
        }
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition(virtualFile, this.project);
        ScriptCompilationConfiguration scriptCompilationConfiguration = scriptConfiguration = scriptDefinition != null ? scriptDefinition.getCompilationConfiguration() : null;
        List<ScriptAcceptedLocation> list2 = scriptScope = scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptIdeConfigurationKt.getAcceptedLocations(ScriptIdeConfigurationKt.getIde(ScriptCompilationConfiguration.Companion))) : null;
        if (scriptScope != null) {
            boolean includeEverything = this.containsAllowedLocations(scriptScope) || ScratchUtil.isScratch((VirtualFile)virtualFile);
            boolean includeLibrariesForScripts = includeEverything || scriptScope.contains((Object)ScriptAcceptedLocation.Libraries);
            boolean includeProjectSourceFilesForScripts = includeEverything || scriptScope.contains((Object)ScriptAcceptedLocation.Sources) || scriptScope.contains((Object)ScriptAcceptedLocation.Tests);
            boolean bl3 = filter2.getIncludeProjectSourceFiles() && includeProjectSourceFilesForScripts;
            boolean bl4 = filter2.getIncludeLibrarySourceFiles() && includeLibrariesForScripts;
            boolean bl5 = filter2.getIncludeLibraryClassFiles() && includeLibrariesForScripts;
            boolean bl6 = filter2.getIncludeScriptDependencies() && includeLibrariesForScripts;
            boolean bl7 = filter2.getIncludeScriptsOutsideSourceRoots() && includeEverything;
            v6 = RootKindFilter.copy$default(filter2, bl3, bl5, bl4, bl6, bl7, false, 32, null);
        } else {
            v6 = correctedFilter = RootKindFilter.copy$default(filter2, false, false, false, false, false, false, 47, null);
        }
        if (correctedFilter.getIncludeScriptsOutsideSourceRoots()) {
            if (this.getFileIndex().isInContent(virtualFile) || ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                return true;
            }
            Object object = scriptConfiguration;
            return object != null && (object = ((PropertiesCollection)object).get(ScriptIdeConfigurationKt.getAcceptedLocations(ScriptIdeConfigurationKt.getIde(ScriptCompilationConfiguration.Companion)))) != null ? this.containsAllowedLocations((List<? extends ScriptAcceptedLocation>)object) : false;
        }
        if (!correctedFilter.getIncludeLibraryClassFiles() && !correctedFilter.getIncludeLibrarySourceFiles()) {
            return false;
        }
        boolean canContainClassFiles = false;
        boolean isBinary = false;
        if (virtualFile.isDirectory()) {
            canContainClassFiles = true;
            isBinary = false;
        } else if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) {
            canContainClassFiles = false;
            isBinary = false;
        } else if (hasBinaryFileExtension) {
            canContainClassFiles = false;
            isBinary = true;
        } else {
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile.getNameSequence());
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
            FileType fileType2 = fileType;
            canContainClassFiles = Intrinsics.areEqual((Object)fileType2, (Object)ArchiveFileType.INSTANCE) || virtualFile.isDirectory();
            isBinary = KotlinBinaryExtensionKt.isKotlinBinary(fileType2);
        }
        if (correctedFilter.getIncludeLibraryClassFiles() && (isBinary || canContainClassFiles)) {
            GlobalSearchScope classFileScope;
            if (this.getFileIndex().isInLibraryClasses(virtualFile)) {
                return true;
            }
            GlobalSearchScope globalSearchScope = classFileScope = correctedFilter.getIncludeScriptDependencies() ? ScriptDependencyAware.Companion.getInstance(this.project).getAllScriptsDependenciesClassFilesScope() : null;
            if (classFileScope != null && classFileScope.contains(virtualFile)) {
                return true;
            }
        }
        if (correctedFilter.getIncludeLibrarySourceFiles() && !isBinary) {
            GlobalSearchScope sourceFileScope;
            if (this.getFileIndex().isInLibrarySource(virtualFile)) {
                return true;
            }
            GlobalSearchScope globalSearchScope = sourceFileScope = correctedFilter.getIncludeScriptDependencies() ? ScriptDependencyAware.Companion.getInstance(this.project).getAllScriptDependenciesSourcesScope() : null;
            if (sourceFileScope != null && sourceFileScope.contains(virtualFile) && (virtualFile instanceof VirtualFileWindow || !this.getFileIndex().isUnderSourceRootOfType(virtualFile, ProjectStructureUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES()))) {
                return true;
            }
        }
        return false;
    }

    private final boolean containsAllowedLocations(List<? extends ScriptAcceptedLocation> $this$containsAllowedLocations) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$containsAllowedLocations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScriptAcceptedLocation it = (ScriptAcceptedLocation)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it == ScriptAcceptedLocation.Everywhere || it == ScriptAcceptedLocation.Project)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final ProjectFileIndex fileIndex_delegate$lambda$0(RootKindMatcherImpl this$0) {
        return ProjectRootManager.getInstance((Project)this$0.project).getFileIndex();
    }
}

