/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.base.analysis.LibraryDependenciesCacheImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.libraryToSourceAnalysis.ResolutionAnchorCacheService;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.util.LibraryDependenciesUtilKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.caches.trackers.ModuleModificationTracker;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;

@com.intellij.openapi.components.State(name="KotlinIdeAnchorService", storages={@Storage(value="anchors.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 02\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0003./0B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u001c\u0010\u000f\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0007J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0'2\u0006\u0010*\u001a\u00020\u001cH\u0016J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020,0\u0011H\u0002J\b\u0010-\u001a\u00020\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR&\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0!0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR(\u0010#\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0!\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001fR&\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0'0&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001f\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/libraryToSourceAnalysis/ResolutionAnchorCacheService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myState", "getState", "loadState", "", "state", "setAnchors", "mapping", "", "", "anchorMappingCachedValue", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl$AnchorMapping;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "anchorMapping", "getAnchorMapping", "()Lorg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl$AnchorMapping;", "resolutionAnchorsForLibraries", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "getResolutionAnchorsForLibraries", "()Ljava/util/Map;", "librariesForResolutionAnchors", "", "getLibrariesForResolutionAnchors", "librariesForResolutionAnchorsIfComputed", "getLibrariesForResolutionAnchorsIfComputed", "resolutionAnchorDependenciesCache", "", "", "getResolutionAnchorDependenciesCache", "getDependencyResolutionAnchors", "libraryInfo", "associateModulesByNames", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "createResolutionAnchorMapping", "State", "AnchorMapping", "Companion", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nResolutionAnchorCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionAnchorCacheService.kt\norg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n1619#2:159\n1863#2:160\n1864#2:162\n1620#2:163\n1202#2,2:164\n1230#2,4:166\n1863#2:170\n1864#2:180\n1#3:161\n119#4:171\n119#4:172\n381#5,7:173\n14#6:181\n*S KotlinDebug\n*F\n+ 1 ResolutionAnchorCacheService.kt\norg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl\n*L\n97#1:159\n97#1:160\n97#1:162\n97#1:163\n115#1:164,2\n115#1:166,4\n136#1:170\n136#1:180\n97#1:161\n137#1:171\n142#1:172\n148#1:173,7\n155#1:181\n*E\n"})
public final class ResolutionAnchorCacheServiceImpl
implements ResolutionAnchorCacheService,
PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @JvmField
    @NotNull
    public volatile State myState;
    @NotNull
    private final CachedValue<AnchorMapping> anchorMappingCachedValue;
    @NotNull
    private static final Logger logger;

    public ResolutionAnchorCacheServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myState = new State(null, 1, null);
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue((UserDataHolder)this.project, () -> ResolutionAnchorCacheServiceImpl.anchorMappingCachedValue$lambda$0(this), false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
        this.anchorMappingCachedValue = cachedValue2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    @TestOnly
    public final void setAnchors(@NotNull Map<String, String> mapping) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        this.myState = new State(mapping);
    }

    private final AnchorMapping getAnchorMapping() {
        Object object = this.anchorMappingCachedValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (AnchorMapping)object;
    }

    @Override
    @NotNull
    public Map<LibraryInfo, ModuleSourceInfo> getResolutionAnchorsForLibraries() {
        return this.getAnchorMapping().getAnchorByLibrary();
    }

    @Override
    @NotNull
    public Map<ModuleSourceInfo, List<LibraryInfo>> getLibrariesForResolutionAnchors() {
        return this.getAnchorMapping().getLibrariesByAnchor();
    }

    @Override
    @Nullable
    public Map<ModuleSourceInfo, List<LibraryInfo>> getLibrariesForResolutionAnchorsIfComputed() {
        Object object = this.anchorMappingCachedValue.getUpToDateOrNull();
        return object != null && (object = (AnchorMapping)object.get()) != null ? ((AnchorMapping)object).getLibrariesByAnchor() : null;
    }

    private final Map<LibraryInfo, Set<ModuleSourceInfo>> getResolutionAnchorDependenciesCache() {
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, () -> ResolutionAnchorCacheServiceImpl._get_resolutionAnchorDependenciesCache_$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Map)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<ModuleSourceInfo> getDependencyResolutionAnchors(@NotNull LibraryInfo libraryInfo) {
        void destination$iv;
        Set<ModuleSourceInfo> $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        Set<ModuleSourceInfo> set = this.getResolutionAnchorDependenciesCache().get(libraryInfo);
        if (set != null) {
            Set<ModuleSourceInfo> it = set;
            boolean bl = false;
            return it;
        }
        Collection<LibraryInfo> allTransitiveLibraryDependencies = LibraryDependenciesUtilKt.getTransitiveLibraryDependencyInfos(LibraryDependenciesCache.Companion.getInstance(this.project), libraryInfo);
        Iterable it = allTransitiveLibraryDependencies;
        Collection bl = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ModuleSourceInfo it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            LibraryInfo it2 = (LibraryInfo)element$iv;
            boolean bl3 = false;
            if (this.getResolutionAnchorsForLibraries().get(it2) == null) continue;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        Set dependencyResolutionAnchors = (Set)destination$iv;
        $this$mapNotNullTo$iv = this.getResolutionAnchorDependenciesCache().putIfAbsent(libraryInfo, dependencyResolutionAnchors);
        if ($this$mapNotNullTo$iv != null) {
            Set<ModuleSourceInfo> it3 = $this$mapNotNullTo$iv;
            boolean bl5 = false;
            return it3;
        }
        TargetPlatform platform = libraryInfo.getPlatform();
        for (LibraryInfo transitiveLibraryDependency : allTransitiveLibraryDependencies) {
            if (!Intrinsics.areEqual((Object)transitiveLibraryDependency.getPlatform(), (Object)platform) || LibraryDependenciesCacheImpl.Companion.isSpecialKotlinCoreLibrary$kotlin_base_analysis(transitiveLibraryDependency, this.project)) continue;
            this.getResolutionAnchorDependenciesCache().putIfAbsent(transitiveLibraryDependency, dependencyResolutionAnchors);
        }
        return dependencyResolutionAnchors;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ModuleInfo> associateModulesByNames() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = ModuleInfosFromIdeaModelKt.getModuleInfosFromIdeaModel$default(this.project, null, 2, null);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string;
            void moduleInfo;
            IdeaModuleInfo ideaModuleInfo = (IdeaModuleInfo)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            void var11_11 = moduleInfo;
            if (var11_11 instanceof LibraryInfo) {
                string = ((LibraryInfo)moduleInfo).getLibrary().getName();
                if (string == null) {
                    string = "";
                }
            } else if (var11_11 instanceof ModuleSourceInfo) {
                String string2 = ((ModuleSourceInfo)moduleInfo).getModule().getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            } else {
                String string3 = moduleInfo.getName().asString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            }
            map.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final AnchorMapping createResolutionAnchorMapping() {
        if (this.myState.getModuleNameToAnchorName().isEmpty()) {
            return new AnchorMapping(MapsKt.emptyMap(), MapsKt.emptyMap());
        }
        Map<String, ModuleInfo> modulesByNames = this.associateModulesByNames();
        Map anchorByLibrary = new LinkedHashMap();
        Map librariesByAnchor = new LinkedHashMap();
        Iterable $this$forEach$iv = this.myState.getModuleNameToAnchorName().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ModuleInfo moduleInfo;
            ModuleInfo library;
            block15: {
                String anchorName;
                block14: {
                    ModuleInfo moduleInfo2;
                    block13: {
                        String libraryName;
                        block12: {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl = false;
                            libraryName = (String)entry.getKey();
                            anchorName = (String)entry.getValue();
                            moduleInfo2 = modulesByNames.get(libraryName);
                            if (moduleInfo2 == null) break block12;
                            ModuleInfo $this$safeAs$iv = moduleInfo2;
                            boolean $i$f$safeAs = false;
                            ModuleInfo moduleInfo3 = $this$safeAs$iv;
                            if (!(moduleInfo3 instanceof LibraryInfo)) {
                                moduleInfo3 = null;
                            }
                            if ((moduleInfo2 = (LibraryInfo)moduleInfo3) != null) break block13;
                        }
                        ResolutionAnchorCacheServiceImpl $this$createResolutionAnchorMapping_u24lambda_u249_u24lambda_u246 = this;
                        boolean bl = false;
                        logger.warn("Resolution anchor mapping key doesn't point to a known library: " + libraryName + ". Skipping this anchor");
                        continue;
                    }
                    library = moduleInfo2;
                    moduleInfo = modulesByNames.get(anchorName);
                    if (moduleInfo == null) break block14;
                    ModuleInfo $this$safeAs$iv = moduleInfo;
                    boolean $i$f$safeAs = false;
                    ModuleInfo moduleInfo4 = $this$safeAs$iv;
                    if (!(moduleInfo4 instanceof ModuleSourceInfo)) {
                        moduleInfo4 = null;
                    }
                    if ((moduleInfo = (ModuleSourceInfo)moduleInfo4) != null) break block15;
                }
                ResolutionAnchorCacheServiceImpl $this$createResolutionAnchorMapping_u24lambda_u249_u24lambda_u247 = this;
                boolean bl = false;
                logger.warn("Resolution anchor mapping value doesn't point to a source module: " + anchorName + ". Skipping this anchor");
                continue;
            }
            ModuleInfo anchor = moduleInfo;
            anchorByLibrary.put(library, anchor);
            Map $this$getOrPut$iv = librariesByAnchor;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(anchor);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(anchor, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(library);
        }
        return new AnchorMapping(anchorByLibrary, librariesByAnchor);
    }

    private static final CachedValueProvider.Result anchorMappingCachedValue$lambda$0(ResolutionAnchorCacheServiceImpl this$0) {
        Object[] objectArray = new Object[]{ModuleModificationTracker.Companion.getInstance(this$0.project), JavaLibraryModificationTracker.getInstance((Project)this$0.project)};
        return CachedValueProvider.Result.create((Object)this$0.createResolutionAnchorMapping(), (Object[])objectArray);
    }

    private static final CachedValueProvider.Result _get_resolutionAnchorDependenciesCache_$lambda$1(ResolutionAnchorCacheServiceImpl this$0) {
        Object[] objectArray = new Object[]{ModuleModificationTracker.Companion.getInstance(this$0.project), JavaLibraryModificationTracker.getInstance((Project)this$0.project)};
        return CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakMap(), (Object[])objectArray);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ResolutionAnchorCacheServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ResolutionAnchorCacheServiceImpl.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl$AnchorMapping;", "", "anchorByLibrary", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "librariesByAnchor", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getAnchorByLibrary", "()Ljava/util/Map;", "getLibrariesByAnchor", "kotlin.base.analysis"})
    private static final class AnchorMapping {
        @NotNull
        private final Map<LibraryInfo, ModuleSourceInfo> anchorByLibrary;
        @NotNull
        private final Map<ModuleSourceInfo, List<LibraryInfo>> librariesByAnchor;

        public AnchorMapping(@NotNull Map<LibraryInfo, ? extends ModuleSourceInfo> anchorByLibrary, @NotNull Map<ModuleSourceInfo, ? extends List<? extends LibraryInfo>> librariesByAnchor) {
            Intrinsics.checkNotNullParameter(anchorByLibrary, (String)"anchorByLibrary");
            Intrinsics.checkNotNullParameter(librariesByAnchor, (String)"librariesByAnchor");
            this.anchorByLibrary = anchorByLibrary;
            this.librariesByAnchor = librariesByAnchor;
        }

        @NotNull
        public final Map<LibraryInfo, ModuleSourceInfo> getAnchorByLibrary() {
            return this.anchorByLibrary;
        }

        @NotNull
        public final Map<ModuleSourceInfo, List<LibraryInfo>> getLibrariesByAnchor() {
            return this.librariesByAnchor;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.base.analysis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R&\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/ResolutionAnchorCacheServiceImpl$State;", "", "moduleNameToAnchorName", "", "", "<init>", "(Ljava/util/Map;)V", "getModuleNameToAnchorName", "()Ljava/util/Map;", "setModuleNameToAnchorName", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.base.analysis"})
    public static final class State {
        @NotNull
        private Map<String, String> moduleNameToAnchorName;

        public State(@NotNull Map<String, String> moduleNameToAnchorName) {
            Intrinsics.checkNotNullParameter(moduleNameToAnchorName, (String)"moduleNameToAnchorName");
            this.moduleNameToAnchorName = moduleNameToAnchorName;
        }

        public /* synthetic */ State(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @NotNull
        public final Map<String, String> getModuleNameToAnchorName() {
            return this.moduleNameToAnchorName;
        }

        public final void setModuleNameToAnchorName(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.moduleNameToAnchorName = map;
        }

        @NotNull
        public final Map<String, String> component1() {
            return this.moduleNameToAnchorName;
        }

        @NotNull
        public final State copy(@NotNull Map<String, String> moduleNameToAnchorName) {
            Intrinsics.checkNotNullParameter(moduleNameToAnchorName, (String)"moduleNameToAnchorName");
            return new State(moduleNameToAnchorName);
        }

        public static /* synthetic */ State copy$default(State state, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = state.moduleNameToAnchorName;
            }
            return state.copy(map);
        }

        @NotNull
        public String toString() {
            return "State(moduleNameToAnchorName=" + this.moduleNameToAnchorName + ")";
        }

        public int hashCode() {
            return ((Object)this.moduleNameToAnchorName).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return Intrinsics.areEqual(this.moduleNameToAnchorName, state.moduleNameToAnchorName);
        }

        public State() {
            this(null, 1, null);
        }
    }
}

