/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManagerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "dependencyManager", "Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "quickFixText", "", "<init>", "(Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;Ljava/lang/String;)V", "getText", "getFamilyName", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "kotlin.code-insight.inspections.shared"})
public final class AddKotlinLibraryQuickFix
implements IntentionAction,
HighPriorityAction {
    @NotNull
    private final KotlinBuildSystemDependencyManager dependencyManager;
    @NotNull
    private final ExternalLibraryDescriptor libraryDescriptor;
    @NotNull
    private final String quickFixText;

    public AddKotlinLibraryQuickFix(@NotNull KotlinBuildSystemDependencyManager dependencyManager, @NotNull ExternalLibraryDescriptor libraryDescriptor, @IntentionName @NotNull String quickFixText) {
        Intrinsics.checkNotNullParameter((Object)dependencyManager, (String)"dependencyManager");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptor, (String)"libraryDescriptor");
        Intrinsics.checkNotNullParameter((Object)quickFixText, (String)"quickFixText");
        this.dependencyManager = dependencyManager;
        this.libraryDescriptor = libraryDescriptor;
        this.quickFixText = quickFixText;
    }

    @NotNull
    public String getText() {
        return this.quickFixText;
    }

    @NotNull
    public String getFamilyName() {
        return this.quickFixText;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = file;
        if (psiFile == null || (psiFile = GenericPsiUtils.getModule((PsiElement)psiFile)) == null) {
            return false;
        }
        PsiFile module = psiFile;
        return this.dependencyManager.isApplicable((Module)module) && !KotlinBuildSystemDependencyManagerKt.isProjectSyncPendingOrInProgress(this.dependencyManager);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (file == null) {
            return;
        }
        PsiFile psiFile = file.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        Module module = GenericPsiUtils.getModule((PsiElement)psiFile2);
        if (module == null) {
            return;
        }
        Module module2 = module;
        ApplicationManager.getApplication().runWriteAction(() -> AddKotlinLibraryQuickFix.invoke$lambda$0(this, module2));
        this.dependencyManager.startProjectSync();
        VirtualFile buildScriptFile = this.dependencyManager.getBuildScriptFile(module2);
        if (buildScriptFile != null) {
            FileEditorManager.getInstance((Project)module2.getProject()).openFile(buildScriptFile, false);
        }
    }

    private static final void invoke$lambda$0(AddKotlinLibraryQuickFix this$0, Module $module) {
        this$0.dependencyManager.addDependency($module, this$0.libraryDescriptor);
    }
}

