/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.google.common.io.Closeables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.VersionComparatorUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleJvmTargetIncompatibilityResults;
import org.jetbrains.kotlin.idea.framework.ui.ChooseModulePanel;
import org.jetbrains.kotlin.idea.framework.ui.KotlinVersionChooser;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002J\b\u0010)\u001a\u00020\nH\u0002J\b\u0010*\u001a\u00020+H\u0002J$\u0010,\u001a\u0004\u0018\u00010\n2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00150\u0014H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR)\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R'\u0010!\u001a\u0018\u0012\b\u0012\u00060\nj\u0002`\"\u0012\n\u0012\b\u0018\u00010\nj\u0002`#0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010 \u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "excludedModules", "", "Lcom/intellij/openapi/module/Module;", "minimumVersion", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;Ljava/util/Collection;Ljava/lang/String;)V", "chooseModulePanel", "Lorg/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel;", "kotlinVersionChooser", "Lorg/jetbrains/kotlin/idea/framework/ui/KotlinVersionChooser;", "listOfKotlinVersionsAndModulesText", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "jvmModulesTargetingUnsupportedJvm", "", "", "rootModuleVersion", "rootModule", "kotlinVersion", "getKotlinVersion", "()Ljava/lang/String;", "modulesToConfigure", "getModulesToConfigure", "()Ljava/util/List;", "versionsAndModules", "getVersionsAndModules", "()Ljava/util/Map;", "modulesAndJvmTargets", "Lorg/jetbrains/kotlin/idea/configuration/ModuleName;", "Lorg/jetbrains/kotlin/idea/configuration/TargetJvm;", "getModulesAndJvmTargets", "createCenterPanel", "Ljavax/swing/JComponent;", "createMessageAboutDifferentKotlinVersions", "currentlySelectedKotlinVersion", "createMessageThatTopLevelAndModulesShouldHaveSameVersion", "showWarningIfThereAreDifferentKotlinVersions", "", "getUnsupportedJvmTargetWarning", "Companion", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nConfigureDialogWithModulesAndVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureDialogWithModulesAndVersion.kt\norg/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n774#2:280\n865#2,2:281\n1863#2,2:283\n1863#2,2:285\n*S KotlinDebug\n*F\n+ 1 ConfigureDialogWithModulesAndVersion.kt\norg/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion\n*L\n133#1:280\n133#1:281,2\n135#1:283,2\n189#1:285,2\n*E\n"})
public final class ConfigureDialogWithModulesAndVersion
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChooseModulePanel chooseModulePanel;
    @NotNull
    private final KotlinVersionChooser kotlinVersionChooser;
    @NotNull
    private final AtomicProperty<String> listOfKotlinVersionsAndModulesText;
    @NotNull
    private final Map<String, List<String>> jvmModulesTargetingUnsupportedJvm;
    @Nullable
    private final String rootModuleVersion;
    @Nullable
    private final Module rootModule;
    @NotNull
    private final Map<String, Map<String, Module>> versionsAndModules;
    @NotNull
    private final Map<String, String> modulesAndJvmTargets;
    @NotNull
    private static final Logger LOG;
    private static final int MODULES_TO_DISPLAY_SIZE = 2;
    @NotNull
    public static final String DEFAULT_KOTLIN_VERSION = "1.9.22";

    public ConfigureDialogWithModulesAndVersion(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator, @NotNull Collection<? extends Module> excludedModules, @NotNull String minimumVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
        Intrinsics.checkNotNullParameter(excludedModules, (String)"excludedModules");
        Intrinsics.checkNotNullParameter((Object)minimumVersion, (String)"minimumVersion");
        super(project);
        this.chooseModulePanel = new ChooseModulePanel(project, configurator, excludedModules);
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.getWindow());
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        this.kotlinVersionChooser = new KotlinVersionChooser(project, minimumVersion, disposable, modalityState);
        this.listOfKotlinVersionsAndModulesText = new AtomicProperty((Object)"");
        this.rootModule = ConfigureKotlinInProjectUtilsKt.getRootModule(project);
        KotlinJ2KOnboardingFUSCollector.logShowConfigureKtWindow(project);
        Object[] objectArray = new Object[]{configurator.getPresentableText()};
        this.setTitle(KotlinProjectConfigurationBundle.message("configure.kotlin.title", objectArray));
        ModuleJvmTargetIncompatibilityResults compatibility = ConfigureKotlinInProjectUtilsKt.checkModuleJvmTargetCompatibility(this.chooseModulePanel.getModules$kotlin_project_configuration(), IdeKotlinVersion.Companion.get(DEFAULT_KOTLIN_VERSION));
        this.jvmModulesTargetingUnsupportedJvm = compatibility.getModulesByIncompatibleJvmTarget();
        this.modulesAndJvmTargets = compatibility.getModuleJvmTargets();
        Pair<Map<String, Map<String, Module>>, String> kotlinVersions = ConfigureKotlinInProjectUtilsKt.getKotlinVersionsAndModules(project, configurator);
        this.versionsAndModules = (Map)kotlinVersions.getFirst();
        this.rootModuleVersion = (String)kotlinVersions.getSecond();
        this.setOKActionEnabled(false);
        this.kotlinVersionChooser.runAfterVersionsLoaded((Function0<Unit>)((Function0)() -> ConfigureDialogWithModulesAndVersion._init_$lambda$0(this)));
        this.kotlinVersionChooser.runAfterVersionSelected((Function1<? super String, Unit>)((Function1)arg_0 -> ConfigureDialogWithModulesAndVersion._init_$lambda$1(this, arg_0)));
        this.chooseModulePanel.notifyOnChange((Function0<Unit>)((Function0)() -> ConfigureDialogWithModulesAndVersion._init_$lambda$2(this)));
        this.init();
    }

    @Nullable
    public final String getKotlinVersion() {
        return this.kotlinVersionChooser.getKotlinVersion();
    }

    @NotNull
    public final List<Module> getModulesToConfigure() {
        return this.chooseModulePanel.getModulesToConfigure();
    }

    @NotNull
    public final Map<String, Map<String, Module>> getVersionsAndModules() {
        return this.versionsAndModules;
    }

    @NotNull
    public final Map<String, String> getModulesAndJvmTargets() {
        return this.modulesAndJvmTargets;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        ObservableProperty kotlinVersionWarningPredicate = PropertyOperationUtil.transform((ObservableProperty)((ObservableProperty)this.listOfKotlinVersionsAndModulesText), ConfigureDialogWithModulesAndVersion::createCenterPanel$lambda$3);
        Ref.BooleanRef oldWarningVisible = new Ref.BooleanRef();
        kotlinVersionWarningPredicate.afterChange(arg_0 -> ConfigureDialogWithModulesAndVersion.createCenterPanel$lambda$5(oldWarningVisible, this, arg_0));
        return (JComponent)BuilderKt.panel(arg_0 -> ConfigureDialogWithModulesAndVersion.createCenterPanel$lambda$11(this, kotlinVersionWarningPredicate, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final String createMessageAboutDifferentKotlinVersions(String currentlySelectedKotlinVersion) {
        void $this$filterTo$iv$iv;
        StringBuilder message2 = new StringBuilder();
        message2.append(KotlinProjectConfigurationBundle.message("configure.kotlin.root.should.contain.same.version", new Object[0]));
        message2.append(KotlinProjectConfigurationBundle.message("configure.kotlin.currently.there.are.versions", new Object[0]));
        Iterable $this$filter$iv = this.versionsAndModules.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)currentlySelectedKotlinVersion))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object[] objectArray;
            Map<String, Module> modules2;
            String it = (String)element$iv;
            boolean bl = false;
            if (this.versionsAndModules.get(it) == null) continue;
            Set<String> modulesNames = modules2.keySet();
            StringBuilder modulesEnumeration = new StringBuilder();
            if (modulesNames.size() > 2) {
                modulesEnumeration.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.take((Iterable)modulesNames, (int)2)), null, null, null, (int)0, null, null, (int)63, null));
                objectArray = new Object[]{modulesNames.size() - 2};
                v0 = modulesEnumeration.append(KotlinProjectConfigurationBundle.message("configure.kotlin.version.and.modules.and.more", objectArray));
            } else {
                v0 = modulesEnumeration.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)modulesNames), null, null, null, (int)0, null, null, (int)63, null));
            }
            objectArray = new Object[]{it, modulesEnumeration.toString()};
            message2.append(KotlinProjectConfigurationBundle.message("configure.kotlin.version.and.modules", objectArray));
        }
        message2.append(KotlinProjectConfigurationBundle.message("configure.kotlin.choose.another.kotlin.version", new Object[0]));
        String string = message2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String createMessageThatTopLevelAndModulesShouldHaveSameVersion() {
        Object[] objectArray = new Object[1];
        String string = this.rootModuleVersion;
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        String string2 = KotlinProjectConfigurationBundle.message("configure.kotlin.root.contains.another.kotlin", objectArray);
        String string3 = KotlinProjectConfigurationBundle.message("configure.kotlin.root.should.contain.same.version", new Object[0]);
        objectArray = new Object[1];
        String string4 = this.rootModuleVersion;
        if (string4 == null) {
            string4 = "";
        }
        objectArray[0] = string4;
        return string2 + string3 + KotlinProjectConfigurationBundle.message("configure.kotlin.choose.the.same.kotlin.version", objectArray);
    }

    private final void showWarningIfThereAreDifferentKotlinVersions() {
        String selectedKotlinVersion = this.getKotlinVersion();
        List<Module> modulesToConfigure = this.chooseModulePanel.getModulesToConfigure();
        if (this.versionsAndModules.isEmpty() || selectedKotlinVersion == null || modulesToConfigure.isEmpty()) {
            this.listOfKotlinVersionsAndModulesText.set((Object)"");
            return;
        }
        String text = CollectionsKt.contains((Iterable)modulesToConfigure, (Object)this.rootModule) && (this.versionsAndModules.size() != 1 || !this.versionsAndModules.containsKey(selectedKotlinVersion)) ? this.createMessageAboutDifferentKotlinVersions(selectedKotlinVersion) : (this.rootModuleVersion != null && !Intrinsics.areEqual((Object)IdeKotlinVersion.Companion.get(this.rootModuleVersion), (Object)IdeKotlinVersion.Companion.get(selectedKotlinVersion)) ? this.createMessageThatTopLevelAndModulesShouldHaveSameVersion() : "");
        this.listOfKotlinVersionsAndModulesText.set((Object)text);
    }

    private final String getUnsupportedJvmTargetWarning(Map<String, ? extends List<String>> jvmModulesTargetingUnsupportedJvm) {
        if (jvmModulesTargetingUnsupportedJvm.isEmpty()) {
            return null;
        }
        StringBuilder message2 = new StringBuilder();
        Object[] objectArray = new Object[]{"1.8"};
        message2.append(KotlinProjectConfigurationBundle.message("configurator.kotlin.jvm.targets.unsupported", objectArray));
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)jvmModulesTargetingUnsupportedJvm.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object[] objectArray2;
            List<String> modulesWithThisTargetVersion;
            String jvmTargetVersion = (String)element$iv;
            boolean bl = false;
            if (jvmModulesTargetingUnsupportedJvm.get(jvmTargetVersion) == null) continue;
            StringBuilder modulesEnumeration = new StringBuilder();
            if (modulesWithThisTargetVersion.size() > 2) {
                modulesEnumeration.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.take((Iterable)modulesWithThisTargetVersion, (int)2)), null, null, null, (int)0, null, null, (int)63, null));
                objectArray2 = new Object[]{modulesWithThisTargetVersion.size() - 2};
                v0 = modulesEnumeration.append(KotlinProjectConfigurationBundle.message("configure.kotlin.jvm.target.in.modules.and.more", objectArray2));
            } else {
                v0 = modulesEnumeration.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)modulesWithThisTargetVersion), null, null, null, (int)0, null, null, (int)63, null));
            }
            objectArray2 = new Object[]{jvmTargetVersion, modulesEnumeration.toString()};
            message2.append(KotlinProjectConfigurationBundle.message("configurator.kotlin.jvm.target.in.modules", objectArray2));
        }
        message2.append(KotlinProjectConfigurationBundle.message("configurator.kotlin.jvm.target.bump.manually.learn.more", new Object[0]));
        return message2.toString();
    }

    private static final Unit _init_$lambda$0(ConfigureDialogWithModulesAndVersion this$0) {
        this$0.setOKActionEnabled(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ConfigureDialogWithModulesAndVersion this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.showWarningIfThereAreDifferentKotlinVersions();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ConfigureDialogWithModulesAndVersion this$0) {
        this$0.showWarningIfThereAreDifferentKotlinVersions();
        return Unit.INSTANCE;
    }

    private static final boolean createCenterPanel$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final void createCenterPanel$lambda$5$lambda$4(ConfigureDialogWithModulesAndVersion this$0) {
        if (!this$0.isShowing()) {
            return;
        }
        this$0.validate();
        this$0.pack();
    }

    private static final Unit createCenterPanel$lambda$5(Ref.BooleanRef $oldWarningVisible, ConfigureDialogWithModulesAndVersion this$0, boolean it) {
        if ($oldWarningVisible.element == it) {
            return Unit.INSTANCE;
        }
        $oldWarningVisible.element = it;
        ApplicationManager.getApplication().invokeLater(() -> ConfigureDialogWithModulesAndVersion.createCenterPanel$lambda$5$lambda$4(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$6(ConfigureDialogWithModulesAndVersion this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.chooseModulePanel.createPanel()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$7(ConfigureDialogWithModulesAndVersion this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.kotlinVersionChooser.createPanel()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$9$lambda$8(String $unsupportedJvmTargetText, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$unsupportedJvmTargetText, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11$lambda$10(ConfigureDialogWithModulesAndVersion this$0, ObservableProperty $kotlinVersionWarningPredicate, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)Row.text$default((Row)$this$row, (String)((String)this$0.listOfKotlinVersionsAndModulesText.get()), (int)0, null, (int)6, null), (ObservableMutableProperty)((ObservableMutableProperty)this$0.listOfKotlinVersionsAndModulesText)).visibleIf($kotlinVersionWarningPredicate).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$11(ConfigureDialogWithModulesAndVersion this$0, ObservableProperty $kotlinVersionWarningPredicate, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ConfigureDialogWithModulesAndVersion.createCenterPanel$lambda$11$lambda$6(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ConfigureDialogWithModulesAndVersion.createCenterPanel$lambda$11$lambda$7(this$0, arg_0), (int)1, null);
        String string = this$0.getUnsupportedJvmTargetWarning(this$0.jvmModulesTargetingUnsupportedJvm);
        if (string != null) {
            String unsupportedJvmTargetText = string;
            boolean bl = false;
            Panel.separator$default((Panel)$this$panel, null, (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> ConfigureDialogWithModulesAndVersion.createCenterPanel$lambda$11$lambda$9$lambda$8(unsupportedJvmTargetText, arg_0), (int)1, null);
        }
        Panel.separator$default((Panel)$this$panel, null, (int)1, null).visibleIf($kotlinVersionWarningPredicate);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ConfigureDialogWithModulesAndVersion.createCenterPanel$lambda$11$lambda$10(this$0, $kotlinVersionWarningPredicate, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> loadVersions(@Nullable String minimumVersion) throws IOException {
        return Companion.loadVersions(minimumVersion);
    }

    static {
        Logger logger = Logger.getInstance(ConfigureDialogWithModulesAndVersion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MODULES_TO_DISPLAY_SIZE", "", "DEFAULT_KOTLIN_VERSION", "", "loadVersions", "", "minimumVersion", "kotlin.project-configuration"})
    @SourceDebugExtension(value={"SMAP\nConfigureDialogWithModulesAndVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureDialogWithModulesAndVersion.kt\norg/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1611#2,9:280\n1863#2:289\n1864#2:292\n1620#2:293\n1#3:290\n1#3:291\n*S KotlinDebug\n*F\n+ 1 ConfigureDialogWithModulesAndVersion.kt\norg/jetbrains/kotlin/idea/framework/ui/ConfigureDialogWithModulesAndVersion$Companion\n*L\n273#1:280,9\n273#1:289\n273#1:292\n273#1:293\n273#1:291\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Collection<String> loadVersions(@Nullable String minimumVersion) throws IOException {
            void $this$mapNotNullTo$iv$iv;
            Object rootElement;
            RepositoryDescription repositoryDescription;
            List versions = new ArrayList();
            IdeKotlinVersion kotlinCompilerVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
            String kotlinArtifactVersion = kotlinCompilerVersion.getArtifactVersion();
            RepositoryDescription repositoryDescription2 = repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(kotlinCompilerVersion);
            if ((repositoryDescription2 != null ? repositoryDescription2.getBintrayUrl() : null) != null) {
                HttpURLConnection httpURLConnection = HttpConfigurable.getInstance().openHttpConnection(repositoryDescription.getBintrayUrl() + kotlinArtifactVersion);
                Intrinsics.checkNotNullExpressionValue((Object)httpURLConnection, (String)"openHttpConnection(...)");
                HttpURLConnection eapConnection = httpURLConnection;
                try {
                    int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
                    eapConnection.setConnectTimeout(timeout);
                    eapConnection.setReadTimeout(timeout);
                    if (eapConnection.getResponseCode() == 200) {
                        versions.add(kotlinArtifactVersion);
                    }
                }
                finally {
                    eapConnection.disconnect();
                }
            }
            String url = Registry.Companion.stringValue("repo.with.kotlin.versions.url");
            HttpURLConnection httpURLConnection = HttpConfigurable.getInstance().openHttpConnection(url);
            Intrinsics.checkNotNullExpressionValue((Object)httpURLConnection, (String)"openHttpConnection(...)");
            HttpURLConnection urlConnection = httpURLConnection;
            try {
                int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
                urlConnection.setConnectTimeout(timeout);
                urlConnection.setReadTimeout(timeout);
                urlConnection.connect();
                InputStreamReader streamReader = new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8);
                try {
                    rootElement = JsonParser.parseReader((Reader)streamReader);
                    JsonArray docsElements = rootElement.getAsJsonObject().get("response").getAsJsonObject().get("docs").getAsJsonArray();
                    Iterator iterator2 = docsElements.iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        JsonElement element = (JsonElement)iterator3.next();
                        String versionNumber = element.getAsJsonObject().get("v").getAsString();
                        if (VersionComparatorUtil.compare((String)minimumVersion, (String)versionNumber) > 0) continue;
                        Intrinsics.checkNotNull((Object)versionNumber);
                        versions.add(versionNumber);
                    }
                }
                finally {
                    Closeables.closeQuietly((Reader)streamReader);
                }
            }
            catch (HttpRequests.HttpStatusException e) {
                LOG.warn("Cannot load data from " + url + " (statusCode=" + e.getStatusCode() + ")", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Error parsing Kotlin versions JSON data: " + e + " (URL=" + url + ")", (Throwable)e);
                throw e;
            }
            finally {
                urlConnection.disconnect();
            }
            Collections.sort(versions, VersionComparatorUtil.COMPARATOR.reversed());
            if (kotlinCompilerVersion.isRelease() && !versions.contains(kotlinArtifactVersion)) {
                versions.add(0, kotlinArtifactVersion);
            }
            Iterable $this$mapNotNull$iv = versions;
            boolean $i$f$mapNotNull = false;
            rootElement = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator4 = $this$forEach$iv$iv$iv.iterator();
            while (iterator4.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator4.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Object object = IdeKotlinVersion.Companion.parse-IoAF18A(it);
                if ((IdeKotlinVersion)(Result.isFailure-impl((Object)object) ? null : object) == null) {
                    string = null;
                } else {
                    IdeKotlinVersion ideVersion;
                    String string2;
                    String it2 = string2 = ideVersion.getRawVersion();
                    boolean bl3 = false;
                    string = ideVersion.isRelease() && !StringsKt.contains$default((CharSequence)it2, (CharSequence)"-", (boolean)false, (int)2, null) ? string2 : null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

