/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleScriptFileChangeListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.legacy.GradleLegacyScriptListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bRA\u0010\f\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptListener;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "legacy", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/legacy/GradleLegacyScriptListener;", "buildRootsManager", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;", "getBuildRootsManager", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;", "fileChangesProcessor", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "filePath", "", "ts", "", "getFileChangesProcessor", "()Lkotlin/jvm/functions/Function2;", "fileChanged", "isApplicable", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCustomScriptingSupport", "editorActivated", "documentChanged", "kotlin.gradle.gradle-java"})
public final class GradleScriptListener
extends ScriptChangeListener {
    @NotNull
    private final GradleLegacyScriptListener legacy;

    public GradleScriptListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.legacy = new GradleLegacyScriptListener(project);
        GradleScriptFileChangeListener listener2 = new GradleScriptFileChangeListener(this, this.getBuildRootsManager());
        VirtualFileChangesListener.Companion.installAsyncVirtualFileListener((VirtualFileChangesListener)listener2, (Disposable)KotlinPluginDisposable.Companion.getInstance(project));
    }

    private final GradleBuildRootsManager getBuildRootsManager() {
        GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(this.getProject());
        if (gradleBuildRootsManager == null) {
            throw new IllegalStateException("GradleBuildRootsManager not found".toString());
        }
        return gradleBuildRootsManager;
    }

    @NotNull
    public final Function2<String, Long, Unit> getFileChangesProcessor() {
        GradleBuildRootsManager buildRootsManager = this.getBuildRootsManager();
        return (arg_0, arg_1) -> GradleScriptListener._get_fileChangesProcessor_$lambda$0(buildRootsManager, arg_0, arg_1);
    }

    public final void fileChanged(@NotNull String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.getFileChangesProcessor().invoke((Object)filePath, (Object)ts);
    }

    @Override
    public boolean isApplicable(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return this.legacy.isApplicable(vFile);
    }

    private final boolean isCustomScriptingSupport(VirtualFile vFile) {
        return this.getBuildRootsManager().isApplicable(vFile);
    }

    @Override
    public void editorActivated(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        if (this.isCustomScriptingSupport(vFile)) {
            this.getBuildRootsManager().updateNotifications(false, (Function1<? super String, Boolean>)((Function1)arg_0 -> GradleScriptListener.editorActivated$lambda$1(vFile, arg_0)));
        } else {
            this.legacy.editorActivated(vFile);
        }
    }

    @Override
    public void documentChanged(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        String string = vFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.fileChanged(string, System.currentTimeMillis());
        if (!this.isCustomScriptingSupport(vFile)) {
            this.legacy.documentChanged(vFile);
        }
    }

    private static final Unit _get_fileChangesProcessor_$lambda$0(GradleBuildRootsManager $buildRootsManager, String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        $buildRootsManager.fileChanged(filePath, ts);
        return Unit.INSTANCE;
    }

    private static final boolean editorActivated$lambda$1(VirtualFile $vFile, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$vFile.getPath());
    }
}

