/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/liveTemplates/KotlinShortenFQNamesProcessor;", "Lcom/intellij/codeInsight/template/impl/TemplateOptionalProcessor;", "<init>", "()V", "processText", "", "project", "Lcom/intellij/openapi/project/Project;", "template", "Lcom/intellij/codeInsight/template/Template;", "document", "Lcom/intellij/openapi/editor/Document;", "templateRange", "Lcom/intellij/openapi/editor/RangeMarker;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getOptionName", "", "isEnabled", "", "setEnabled", "value", "isVisible", "context", "Lcom/intellij/codeInsight/template/impl/TemplateContext;", "kotlin.code-insight.live-templates.shared"})
public final class KotlinShortenFQNamesProcessor
implements TemplateOptionalProcessor {
    public void processText(@NotNull Project project, @NotNull Template template2, @NotNull Document document, @NotNull RangeMarker templateRange, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)templateRange, (String)"templateRange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!template2.isToShortenLongNames()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile file = ktFile2;
        ShortenReferencesFacility shortenReferencesFacility = ShortenReferencesFacility.Companion.getInstance();
        TextRange textRange = templateRange.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        shortenReferencesFacility.shorten(file, textRange);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
    }

    @NotNull
    public String getOptionName() {
        String string = CodeInsightBundle.message((String)"dialog.edit.template.checkbox.shorten.fq.names", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isEnabled(@NotNull Template template2) {
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        return template2.isToShortenLongNames();
    }

    public void setEnabled(@NotNull Template template2, boolean value) {
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
    }

    public boolean isVisible(@NotNull Template template2, @NotNull TemplateContext context2) {
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return false;
    }
}

