/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.navigation.ItemPresentation;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotatedFilePresentation;", "Lcom/intellij/navigation/ItemPresentation;", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getPresentableText", "", "getLocationString", "getIcon", "Ljavax/swing/Icon;", "unused", "", "kotlin.base.analysis"})
public final class KtJvmNameAnnotatedFilePresentation
implements ItemPresentation {
    @NotNull
    private final KtAnnotationEntry annotationEntry;
    @NotNull
    private final KtFile containingFile;

    public KtJvmNameAnnotatedFilePresentation(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        this.annotationEntry = annotationEntry2;
        KtFile ktFile2 = this.annotationEntry.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        this.containingFile = ktFile2;
    }

    @Nullable
    public String getPresentableText() {
        return JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(this.annotationEntry);
    }

    @NotNull
    public String getLocationString() {
        Object[] objectArray = new Object[]{this.containingFile.getName(), this.containingFile.getPackageFqName()};
        return KotlinBundle.message((String)"presentation.text.in.container", (Object[])objectArray);
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        Icon icon2 = KotlinIcons.FILE;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FILE");
        return icon2;
    }
}

