/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixFE10Kt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "startInWriteAction", "", "invokeImpl", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailableImpl", "Companion", "MakeClassOpenFactory", "AddLateinitFactory", "kotlin.idea"})
public class AddModifierFixFE10
extends AddModifierFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddModifierFixFE10(@NotNull KtModifierListOwner element, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        super(element, modifier);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startInWriteAction() {
        boolean bl;
        if (!AddModifierFixFE10.Companion.isMultiplatformPersistent(this.getModifier())) return true;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner != null) {
            if (PsiUtilsKt.hasActualModifier((KtModifierListOwner)ktModifierListOwner)) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        KtModifierListOwner ktModifierListOwner2 = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner2 == null) return true;
        if (!PsiUtilsKt.hasExpectModifier((KtModifierListOwner)ktModifierListOwner2)) return true;
        return false;
    }

    @Override
    protected void invokeImpl(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtModifierListOwner originalElement = (KtModifierListOwner)this.getElement();
        if (originalElement instanceof KtDeclaration && AddModifierFixFE10.Companion.isMultiplatformPersistent(this.getModifier())) {
            OkCancelDialogBuilder dialog2;
            Set<KtDeclaration> elementsToMutate = ExpectActualUtilKt.collectAllExpectAndActualDeclaration((KtDeclaration)originalElement, true);
            if (elementsToMutate.size() > 1 && AddModifierFix.Companion.getModifiersWithWarning().contains(this.getModifier()) && !(dialog2 = (OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(KotlinBundle.message((String)"fix.potentially.broken.inheritance.title", (Object[])new Object[0]), KotlinBundle.message((String)"fix.potentially.broken.inheritance.message", (Object[])new Object[0])).asWarning()).ask(project)) {
                return;
            }
            ApplicationUtilsKt.runWriteActionIfPhysical((PsiElement)originalElement, () -> AddModifierFixFE10.invokeImpl$lambda$0(elementsToMutate, this));
        } else {
            this.invokeOnElement(originalElement);
        }
    }

    @Override
    protected boolean isAvailableImpl(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner == null) {
            return false;
        }
        KtModifierListOwner element = ktModifierListOwner;
        return KotlinRefactoringUtilKt.canRefactor((PsiElement)element);
    }

    private static final Unit invokeImpl$lambda$0(Set $elementsToMutate, AddModifierFixFE10 this$0) {
        for (KtDeclaration declaration : $elementsToMutate) {
            this$0.invokeOnElement((KtModifierListOwner)declaration);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10$AddLateinitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class AddLateinitFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final AddLateinitFactory INSTANCE = new AddLateinitFactory();

        private AddLateinitFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = ((SimpleDiagnostic)Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"<get-psiElement>(...)");
            KtProperty property = (KtProperty)psiElement;
            if (!property.isVar()) {
                return null;
            }
            VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny(property, BodyResolveMode.FULL);
            if (variableDescriptor == null) {
                return null;
            }
            VariableDescriptor descriptor2 = variableDescriptor;
            PropertyDescriptor propertyDescriptor = descriptor2 instanceof PropertyDescriptor ? (PropertyDescriptor)descriptor2 : null;
            if (propertyDescriptor == null || (propertyDescriptor = propertyDescriptor.getType()) == null) {
                return null;
            }
            PropertyDescriptor type2 = propertyDescriptor;
            if (TypeUtils.isNullableType((KotlinType)type2)) {
                return null;
            }
            if (KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)property;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.LATEINIT_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"LATEINIT_KEYWORD");
            return new AddModifierFixFE10(ktModifierListOwner, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10;", "<init>", "()V", "isMultiplatformPersistent", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "createModifierFix", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifier", "kotlin.idea"})
    public static final class Companion
    implements AddModifierFix.Factory<AddModifierFixFE10> {
        private Companion() {
        }

        private final boolean isMultiplatformPersistent(KtModifierKeywordToken $this$isMultiplatformPersistent) {
            return KtTokens.MODALITY_MODIFIERS.contains((IElementType)$this$isMultiplatformPersistent) || Intrinsics.areEqual((Object)$this$isMultiplatformPersistent, (Object)KtTokens.INLINE_KEYWORD);
        }

        @Override
        @NotNull
        public AddModifierFixFE10 createModifierFix(@NotNull KtModifierListOwner element, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return new AddModifierFixFE10(element, modifier);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixFE10$MakeClassOpenFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class MakeClassOpenFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final MakeClassOpenFactory INSTANCE = new MakeClassOpenFactory();

        private MakeClassOpenFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            KtTypeReference typeReference = (KtTypeReference)psiElement;
            KtClass ktClass = AddModifierFixFE10Kt.classForRefactor(typeReference);
            if (ktClass == null) {
                return null;
            }
            KtClass declaration = ktClass;
            if (declaration.isAnnotation() || declaration.isEnum() || declaration.isData() || KotlinPsiUtils.isInlineOrValue(declaration)) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)declaration;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OPEN_KEYWORD");
            return new AddModifierFixFE10(ktModifierListOwner, ktModifierKeywordToken);
        }
    }
}

