/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.MakeConstructorParameterPropertyFix;
import org.jetbrains.kotlin.idea.quickfix.MakeConstructorParameterPropertyFixKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeConstructorParameterPropertyFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "<init>", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class MakeConstructorParameterPropertyFixFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final MakeConstructorParameterPropertyFixFactory INSTANCE = new MakeConstructorParameterPropertyFixFactory();

    private MakeConstructorParameterPropertyFixFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Object object = ((DiagnosticWithParameters1)Errors.UNRESOLVED_REFERENCE.cast((UnboundDiagnostic)diagnostic)).getA();
        KtNameReferenceExpression ktNameReferenceExpression = object instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)object : null;
        if (ktNameReferenceExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtNameReferenceExpression ktReference = ktNameReferenceExpression;
        KotlinValVar valOrVar = KtPsiUtilKt.getAssignmentByLHS((KtExpression)((KtExpression)ktReference)) != null ? KotlinValVar.Var : KotlinValVar.Val;
        KtParameter ktParameter = MakeConstructorParameterPropertyFixKt.getPrimaryConstructorParameterWithSameName(ktReference);
        if (ktParameter == null) {
            return CollectionsKt.emptyList();
        }
        KtParameter ktParameter2 = ktParameter;
        if (ktParameter2.hasValOrVar()) {
            return CollectionsKt.emptyList();
        }
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktParameter2));
        Intrinsics.checkNotNull((Object)ktClass);
        KtClass containingClass = ktClass;
        String className = !Intrinsics.areEqual((Object)containingClass, (Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)ktReference))) ? containingClass.getNameAsSafeName().asString() : null;
        return CollectionsKt.listOf((Object)new MakeConstructorParameterPropertyFix(ktParameter2, valOrVar, className).asIntention());
    }
}

