/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.repl;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "history", "Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "osProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "startExecution", "", "stopExecution", "callback", "Lkotlin/Function0;", "clearState", "executeStatement", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "needProcessToStart", "", "sendCommandToProcess", "command", "", "ReplHistory", "ReplOSProcessHandler", "kotlin.jvm"})
public final class KtScratchReplExecutor
extends SequentialScratchExecutor {
    @NotNull
    private final ReplHistory history;
    @Nullable
    private volatile OSProcessHandler osProcessHandler;

    public KtScratchReplExecutor(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file);
        this.history = new ReplHistory();
    }

    @Override
    protected void startExecution() {
        block0: {
            Module module = this.getFile().getModule();
            Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = KotlinConsoleKeeper.Companion.createReplCommandLine(this.getFile().getProject(), module);
            TargetEnvironmentRequest environmentRequest = (TargetEnvironmentRequest)pair.component1();
            TargetedCommandLine cmdLine = (TargetedCommandLine)pair.component2();
            TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"EMPTY");
            TargetEnvironment environment = environmentRequest.prepareEnvironment(targetProgressIndicator);
            String commandPresentation = cmdLine.getCommandPresentation(environment);
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Execute REPL: " + commandPresentation);
            OSProcessHandler oSProcessHandler = this.osProcessHandler = (OSProcessHandler)new ReplOSProcessHandler(environment.createProcess(cmdLine, (ProgressIndicator)new EmptyProgressIndicator()), commandPresentation);
            if (oSProcessHandler == null) break block0;
            oSProcessHandler.startNotify();
        }
    }

    @Override
    protected void stopExecution(@Nullable Function0<Unit> callback2) {
        OSProcessHandler processHandler = this.osProcessHandler;
        if (processHandler == null) {
            Function0<Unit> function0 = callback2;
            if (function0 != null) {
                function0.invoke();
            }
            return;
        }
        try {
            if (callback2 != null) {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(callback2){
                    final /* synthetic */ Function0<Unit> $callback;
                    {
                        this.$callback = $callback;
                    }

                    public void processTerminated(ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$callback.invoke();
                    }
                });
            }
            this.sendCommandToProcess(":quit");
        }
        catch (Exception e) {
            this.errorOccurs(KotlinJvmBundle.message("couldn.t.stop.repl.process", new Object[0]), e, false);
            processHandler.destroyProcess();
            this.clearState();
        }
    }

    private final void clearState() {
        this.history.clear();
        this.osProcessHandler = null;
        this.getHandler().onFinish(this.getFile());
    }

    @Override
    public void executeStatement(@NotNull ScratchExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.needProcessToStart()) {
            this.startExecution();
        }
        this.history.addEntry(expression);
        try {
            Object object = ActionsKt.runReadAction(() -> KtScratchReplExecutor.executeStatement$lambda$0(expression));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            this.sendCommandToProcess((String)object);
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{expression.getElement().getText()};
            this.errorOccurs(KotlinJvmBundle.message("couldn.t.execute.statement.0", objectArray), e, true);
        }
    }

    @Override
    protected boolean needProcessToStart() {
        return this.osProcessHandler == null;
    }

    private final void sendCommandToProcess(String command) {
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Send to REPL: " + command);
        Object object = this.osProcessHandler;
        if (object == null || (object = object.getProcessInput()) == null) {
            RunExecuteActionsKt.logError$default(this.getClass(), "<p>Broken execute stream</p>", null, 4, null);
            return;
        }
        Object processInputOS = object;
        Object object2 = this.osProcessHandler;
        if (object2 == null || (object2 = object2.getCharset()) == null) {
            object2 = Charsets.UTF_8;
        }
        Object charset = object2;
        String xmlRes = ReplUtilKt.replInputAsXml((String)command);
        byte[] byArray = (xmlRes + "\n").getBytes((Charset)charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        ((OutputStream)processInputOS).write(bytes);
        ((OutputStream)processInputOS).flush();
    }

    private static final String executeStatement$lambda$0(ScratchExpression $expression) {
        return $expression.getElement().getText();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\r\u001a\u0004\u0018\u00010\u0006J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory;", "", "<init>", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Lkotlin/collections/ArrayList;", "processedEntriesCount", "", "addEntry", "", "entry", "lastUnprocessedEntry", "lastProcessedEntry", "entryProcessed", "clear", "isAllProcessed", "", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nKtScratchReplExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtScratchReplExecutor.kt\norg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplHistory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
    private static final class ReplHistory {
        @NotNull
        private ArrayList<ScratchExpression> entries = new ArrayList();
        private int processedEntriesCount;

        public final void addEntry(@NotNull ScratchExpression entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entries.add(entry);
        }

        @Nullable
        public final ScratchExpression lastUnprocessedEntry() {
            ArrayList<ScratchExpression> arrayList;
            ArrayList<ScratchExpression> it = arrayList = this.entries;
            boolean bl = false;
            ArrayList<ScratchExpression> arrayList2 = this.processedEntriesCount < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(this.processedEntriesCount) : null;
        }

        @Nullable
        public final ScratchExpression lastProcessedEntry() {
            ArrayList<ScratchExpression> arrayList;
            if (this.processedEntriesCount < 1) {
                return null;
            }
            int lastProcessedEntryIndex = this.processedEntriesCount - 1;
            ArrayList<ScratchExpression> it = arrayList = this.entries;
            boolean bl = false;
            ArrayList<ScratchExpression> arrayList2 = lastProcessedEntryIndex < this.entries.size() ? arrayList : null;
            return arrayList2 != null ? arrayList2.get(lastProcessedEntryIndex) : null;
        }

        public final void entryProcessed() {
            int n = this.processedEntriesCount;
            this.processedEntriesCount = n + 1;
        }

        public final void clear() {
            this.entries = new ArrayList();
            this.processedEntriesCount = 0;
        }

        public final boolean isAllProcessed() {
            return this.entries.size() == this.processedEntriesCount;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor$ReplOSProcessHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "Ljava/lang/Process;", "commandLine", "", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/repl/KtScratchReplExecutor;Ljava/lang/Process;Ljava/lang/String;)V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "Ljavax/xml/parsers/DocumentBuilderFactory;", "notifyTextAvailable", "", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "notifyProcessTerminated", "exitCode", "", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "handleReplMessage", "parseReplOutput", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "kotlin.jvm"})
    private final class ReplOSProcessHandler
    extends OSProcessHandler {
        private final DocumentBuilderFactory factory;

        public ReplOSProcessHandler(@NotNull Process process2, String commandLine) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            super(process2, commandLine);
            this.factory = DocumentBuilderFactory.newInstance();
        }

        public void notifyTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            if (StringsKt.startsWith$default((String)text, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
                return;
            }
            Key<?> key = outputType;
            if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) {
                this.handleReplMessage(text);
            } else if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDERR)) {
                ScratchExecutor.errorOccurs$default(KtScratchReplExecutor.this, text, null, false, 6, null);
            }
        }

        protected void notifyProcessTerminated(int exitCode) {
            KtScratchReplExecutor.this.clearState();
            super.notifyProcessTerminated(exitCode);
        }

        private final InputSource strToSource(String s, Charset encoding) {
            byte[] byArray = s.getBytes(encoding);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return new InputSource(new ByteArrayInputStream(byArray));
        }

        static /* synthetic */ InputSource strToSource$default(ReplOSProcessHandler replOSProcessHandler, String string, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return replOSProcessHandler.strToSource(string, charset);
        }

        private final void handleReplMessage(String text) {
            Document document;
            if (StringsKt.isBlank((CharSequence)text)) {
                return;
            }
            try {
                document = this.factory.newDocumentBuilder().parse(ReplOSProcessHandler.strToSource$default(this, text, null, 2, null));
            }
            catch (Exception e) {
                KtScratchReplExecutor.this.getHandler().error(KtScratchReplExecutor.this.getFile(), "Couldn't parse REPL output: " + text);
                return;
            }
            Document output = document;
            Node node = output.getFirstChild();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element root = (Element)node;
            String outputType = root.getAttribute("type");
            String string = root.getTextContent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextContent(...)");
            String content = ReplUtilKt.replRemoveLineBreaksInTheEnd((String)ReplUtilKt.replNormalizeLineBreaks((String)ReplUtilKt.replUnescapeLineBreaks((String)string)));
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "REPL output: " + outputType + " " + content);
            Object[] objectArray = new String[]{"SUCCESS", "COMPILE_ERROR", "INTERNAL_ERROR", "RUNTIME_ERROR", "READLINE_END"};
            if (SetsKt.setOf((Object[])objectArray).contains(outputType)) {
                KtScratchReplExecutor.this.history.entryProcessed();
                if (KtScratchReplExecutor.this.history.isAllProcessed()) {
                    KtScratchReplExecutor.this.getHandler().onFinish(KtScratchReplExecutor.this.getFile());
                }
            }
            Intrinsics.checkNotNull((Object)outputType);
            ScratchOutput result2 = this.parseReplOutput(content, outputType);
            if (result2 != null) {
                ScratchExpression lastExpression;
                ScratchExpression scratchExpression = lastExpression = Intrinsics.areEqual((Object)outputType, (Object)"USER_OUTPUT") ? KtScratchReplExecutor.this.history.lastUnprocessedEntry() : KtScratchReplExecutor.this.history.lastProcessedEntry();
                if (lastExpression != null) {
                    KtScratchReplExecutor.this.getHandler().handle(KtScratchReplExecutor.this.getFile(), lastExpression, result2);
                }
            }
        }

        private final ScratchOutput parseReplOutput(String text, String outputType) {
            return switch (outputType) {
                case "USER_OUTPUT" -> new ScratchOutput(text, ScratchOutputType.OUTPUT);
                case "REPL_RESULT" -> new ScratchOutput(text, ScratchOutputType.RESULT);
                case "RUNTIME_ERROR", "INTERNAL_ERROR", "COMPILE_ERROR", "REPL_INCOMPLETE" -> new ScratchOutput(text, ScratchOutputType.ERROR);
                default -> null;
            };
        }
    }
}

