/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;

public class GradleExecutionSettings
extends ExternalSystemExecutionSettings {
    private static final boolean USE_VERBOSE_GRADLE_API_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("gradle.api.verbose"));
    @NotNull
    private final GradleExecutionWorkspace myExecutionWorkspace;
    @Nullable
    private final String myGradleHome;
    @Nullable
    private final String myServiceDirectory;
    private final boolean myIsOfflineWork;
    @NotNull
    private final DistributionType myDistributionType;
    @Nullable
    private String wrapperPropertyFile;
    @Nullable
    private String myJavaHome;
    @Nullable
    private String myIdeProjectPath;
    private boolean resolveModulePerSourceSet;
    private boolean useQualifiedModuleNames;
    private boolean delegatedBuild;
    private boolean downloadSources;
    private boolean isParallelModelFetch;
    private boolean myBuiltInTestEventsUsed;

    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, boolean isOfflineWork) {
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(0);
        }
        this.myExecutionWorkspace = new GradleExecutionWorkspace();
        this.resolveModulePerSourceSet = true;
        this.useQualifiedModuleNames = false;
        this.delegatedBuild = true;
        this.downloadSources = false;
        this.isParallelModelFetch = false;
        this.myBuiltInTestEventsUsed = false;
        this.myGradleHome = gradleHome;
        this.myServiceDirectory = serviceDirectory;
        this.myDistributionType = distributionType;
        this.myIsOfflineWork = isOfflineWork;
        this.setVerboseProcessing(USE_VERBOSE_GRADLE_API_BY_DEFAULT);
    }

    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, @Nullable String daemonVmOptions, boolean isOfflineWork) {
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(1);
        }
        this.myExecutionWorkspace = new GradleExecutionWorkspace();
        this.resolveModulePerSourceSet = true;
        this.useQualifiedModuleNames = false;
        this.delegatedBuild = true;
        this.downloadSources = false;
        this.isParallelModelFetch = false;
        this.myBuiltInTestEventsUsed = false;
        this.myGradleHome = gradleHome;
        this.myServiceDirectory = serviceDirectory;
        this.myDistributionType = distributionType;
        if (daemonVmOptions != null) {
            this.withVmOptions(ParametersListUtil.parse((String)daemonVmOptions));
        }
        this.myIsOfflineWork = isOfflineWork;
        this.setVerboseProcessing(USE_VERBOSE_GRADLE_API_BY_DEFAULT);
    }

    public void setIdeProjectPath(@Nullable String ideProjectPath) {
        this.myIdeProjectPath = ideProjectPath;
    }

    @Nullable
    public String getIdeProjectPath() {
        return this.myIdeProjectPath;
    }

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    @Nullable
    public String getServiceDirectory() {
        return this.myServiceDirectory;
    }

    @Nullable
    public String getJavaHome() {
        return this.myJavaHome;
    }

    public void setJavaHome(@Nullable String javaHome) {
        this.myJavaHome = javaHome;
    }

    public boolean isOfflineWork() {
        return this.myIsOfflineWork;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean resolveModulePerSourceSet) {
        this.resolveModulePerSourceSet = resolveModulePerSourceSet;
    }

    public boolean isUseQualifiedModuleNames() {
        return this.useQualifiedModuleNames;
    }

    public void setUseQualifiedModuleNames(boolean useQualifiedModuleNames) {
        this.useQualifiedModuleNames = useQualifiedModuleNames;
    }

    public boolean isDelegatedBuild() {
        return this.delegatedBuild;
    }

    public void setDelegatedBuild(boolean delegatedBuild) {
        this.delegatedBuild = delegatedBuild;
    }

    @Nullable
    public String getWrapperPropertyFile() {
        return this.wrapperPropertyFile;
    }

    public void setWrapperPropertyFile(@Nullable String wrapperPropertyFile) {
        this.wrapperPropertyFile = wrapperPropertyFile;
    }

    @NotNull
    public DistributionType getDistributionType() {
        DistributionType distributionType = this.myDistributionType;
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(2);
        }
        return distributionType;
    }

    @NotNull
    public GradleExecutionWorkspace getExecutionWorkspace() {
        GradleExecutionWorkspace gradleExecutionWorkspace = this.myExecutionWorkspace;
        if (gradleExecutionWorkspace == null) {
            GradleExecutionSettings.$$$reportNull$$$0(3);
        }
        return gradleExecutionWorkspace;
    }

    public boolean isDebugAllEnabled() {
        Boolean value = (Boolean)this.getUserData(GradleRunConfiguration.DEBUG_ALL_KEY);
        return (Boolean)ObjectUtils.chooseNotNull((Object)value, (Object)false);
    }

    public boolean isRunAsTest() {
        Boolean value = (Boolean)this.getUserData(GradleRunConfiguration.RUN_AS_TEST_KEY);
        return (Boolean)ObjectUtils.chooseNotNull((Object)value, (Object)false);
    }

    public void setRunAsTest(boolean isRunAsTest) {
        this.putUserData(GradleRunConfiguration.RUN_AS_TEST_KEY, isRunAsTest);
    }

    public boolean isTestTaskRerun() {
        Boolean value = (Boolean)this.getUserData(GradleRunConfiguration.IS_TEST_TASK_RERUN_KEY);
        return (Boolean)ObjectUtils.chooseNotNull((Object)value, (Object)false);
    }

    public boolean isBuiltInTestEventsUsed() {
        return this.myBuiltInTestEventsUsed;
    }

    public void setBuiltInTestEventsUsed(boolean isBuiltInTestEventsUsed) {
        this.myBuiltInTestEventsUsed = isBuiltInTestEventsUsed;
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public boolean isParallelModelFetch() {
        return this.isParallelModelFetch;
    }

    public void setParallelModelFetch(boolean parallelModelFetch) {
        this.isParallelModelFetch = parallelModelFetch;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myGradleHome != null ? this.myGradleHome.hashCode() : 0);
        result = 31 * result + (this.myServiceDirectory != null ? this.myServiceDirectory.hashCode() : 0);
        result = 31 * result + this.myDistributionType.hashCode();
        result = 31 * result + (this.myJavaHome != null ? this.myJavaHome.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GradleExecutionSettings that = (GradleExecutionSettings)((Object)o);
        if (this.myDistributionType != that.myDistributionType) {
            return false;
        }
        if (!Objects.equals(this.myGradleHome, that.myGradleHome)) {
            return false;
        }
        if (!Objects.equals(this.myJavaHome, that.myJavaHome)) {
            return false;
        }
        return Objects.equals(this.myServiceDirectory, that.myServiceDirectory);
    }

    public String toString() {
        return "home: " + this.myGradleHome + ", distributionType: " + this.myDistributionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistributionType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

