/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserDictionary
implements EditableDictionary {
    private final String name;
    @NotNull
    private final Set<String> words;

    public UserDictionary(@NotNull String name) {
        if (name == null) {
            UserDictionary.$$$reportNull$$$0(0);
        }
        this.words = CollectionFactory.createSmallMemoryFootprintSet();
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            UserDictionary.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        boolean contains;
        if (word == null) {
            UserDictionary.$$$reportNull$$$0(2);
        }
        return (contains = this.words.contains(word)) ? Boolean.valueOf(true) : null;
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        Set<String> set = this.words;
        if (set == null) {
            UserDictionary.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getEditableWords() {
        Set<String> set = this.words;
        if (set == null) {
            UserDictionary.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public void clear() {
        this.words.clear();
    }

    @Override
    public void addToDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.add(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.remove(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words2) {
        this.clear();
        this.addToDictionary(words2);
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words2) {
        if (words2 == null || words2.isEmpty()) {
            return;
        }
        for (String word : words2) {
            this.addToDictionary(word);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDictionary that = (UserDictionary)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NonNls
    public String toString() {
        return "UserDictionary{name='" + this.name + "', words.count=" + this.words.size() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/dictionary/UserDictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/dictionary/UserDictionary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

