/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventFieldName;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B?\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0004\b\u000b\u0010\fB3\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0004\b\u000b\u0010\rJ\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u00c2\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\nH\u00c2\u0003JK\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0003\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "T", "", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "name", "", "enumClass", "Ljava/lang/Class;", "description", "transform", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "getDescription", "addData", "", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value", "(Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;Ljava/lang/Enum;)V", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
public final class EnumEventField<T extends Enum<?>>
extends PrimitiveEventField<T> {
    @NotNull
    private final String name;
    @NotNull
    private final Class<T> enumClass;
    @Nullable
    private final String description;
    @NotNull
    private final Function1<T, String> transform;

    public EnumEventField(@EventFieldName @NonNls @NotNull String name, @NotNull Class<T> enumClass, @NonNls @Nullable String description, @NotNull Function1<? super T, String> transform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        super(null, 1, null);
        this.name = name;
        this.enumClass = enumClass;
        this.description = description;
        this.transform = transform;
    }

    public /* synthetic */ EnumEventField(String string, Class clazz, String string2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, clazz, string2, function1);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public EnumEventField(@NotNull String name, @NotNull Class<T> enumClass, @NotNull Function1<? super T, String> transform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this(name, enumClass, null, transform);
    }

    @Override
    public void addData(@NotNull FeatureUsageData fuData, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        fuData.addData(this.getName(), (String)this.transform.invoke(value));
    }

    @Override
    @NotNull
    public List<String> getValidationRule() {
        Object[] objectArray = this.enumClass.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
        return CollectionsKt.listOf((Object)("{enum:" + ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"|", null, null, (int)0, null, this.transform, (int)30, null) + "}"));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    private final Class<T> component2() {
        return this.enumClass;
    }

    @Nullable
    public final String component3() {
        return this.description;
    }

    private final Function1<T, String> component4() {
        return this.transform;
    }

    @NotNull
    public final EnumEventField<T> copy(@EventFieldName @NonNls @NotNull String name, @NotNull Class<T> enumClass, @NonNls @Nullable String description, @NotNull Function1<? super T, String> transform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return new EnumEventField<T>(name, enumClass, description, transform);
    }

    public static /* synthetic */ EnumEventField copy$default(EnumEventField enumEventField, String string, Class clazz, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = enumEventField.name;
        }
        if ((n & 2) != 0) {
            clazz = enumEventField.enumClass;
        }
        if ((n & 4) != 0) {
            string2 = enumEventField.description;
        }
        if ((n & 8) != 0) {
            function1 = enumEventField.transform;
        }
        return enumEventField.copy(string, clazz, string2, function1);
    }

    @NotNull
    public String toString() {
        return "EnumEventField(name=" + this.name + ", enumClass=" + this.enumClass + ", description=" + this.description + ", transform=" + this.transform + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.enumClass.hashCode();
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + this.transform.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnumEventField)) {
            return false;
        }
        EnumEventField enumEventField = (EnumEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)enumEventField.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.enumClass, enumEventField.enumClass)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)enumEventField.description)) {
            return false;
        }
        return Intrinsics.areEqual(this.transform, enumEventField.transform);
    }
}

