/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.ignore.IgnoredToExcludedSynchronizer;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.util.paths.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRefreshUsageCollector;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.index.LightFileStatus;
import git4idea.repo.CopyOnWriteFilePathSet;
import git4idea.repo.GitRepository;
import git4idea.status.GitRefreshListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GitUntrackedFilesHolder
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final GitRepository myRepository;
    private final Set<FilePath> myDirtyFiles;
    private boolean myEverythingDirty;
    private final MergingUpdateQueue myQueue;
    private final Object LOCK;
    private boolean myInUpdate;
    private final CopyOnWriteFilePathSet myUntrackedFiles;
    private final MyGitRepositoryIgnoredFilesHolder myIgnoredFilesHolder;

    GitUntrackedFilesHolder(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(0);
        }
        this.myDirtyFiles = new HashSet<FilePath>();
        this.myEverythingDirty = true;
        this.LOCK = new Object();
        this.myInUpdate = false;
        this.myRepository = repository;
        this.myProject = repository.getProject();
        this.myRoot = repository.getRoot();
        this.myUntrackedFiles = new CopyOnWriteFilePathSet(this.myRoot.isCaseSensitive());
        this.myIgnoredFilesHolder = new MyGitRepositoryIgnoredFilesHolder();
        this.myQueue = VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).getIgnoreRefreshQueue();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myUntrackedFiles.clear();
            this.myIgnoredFilesHolder.clear();
            this.myDirtyFiles.clear();
        }
    }

    public void addUntracked(@NotNull FilePath file) {
        if (file == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(1);
        }
        this.addUntracked(Collections.singletonList(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUntracked(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myUntrackedFiles.add(files);
            if (!this.myEverythingDirty) {
                this.myDirtyFiles.addAll(files);
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUntracked(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(3);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myUntrackedFiles.remove(files);
            if (!this.myEverythingDirty) {
                this.myDirtyFiles.addAll(files);
            }
        }
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPossiblyUntracked(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(4);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myEverythingDirty) {
                return;
            }
            for (FilePath filePath : files) {
                if (!this.myIgnoredFilesHolder.ignoredFiles.containsExplicitly(filePath) && this.myIgnoredFilesHolder.ignoredFiles.hasAncestor(filePath)) continue;
                this.myDirtyFiles.add(filePath);
            }
        }
        this.scheduleUpdate();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        List list = ContainerUtil.mapNotNull(this.retrieveUntrackedFilePaths(), FilePath::getVirtualFile);
        if (list == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(5);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myEverythingDirty = true;
            this.myDirtyFiles.clear();
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUpdateMode() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myInUpdate;
        }
    }

    @NotNull
    public Collection<FilePath> getUntrackedFilePaths() {
        Set<FilePath> set = this.myUntrackedFiles.toSet();
        if (set == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(6);
        }
        return set;
    }

    public boolean containsUntrackedFile(@NotNull FilePath filePath) {
        if (filePath == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(7);
        }
        return this.myUntrackedFiles.hasAncestor(filePath);
    }

    @NotNull
    public Collection<FilePath> retrieveUntrackedFilePaths() throws VcsException {
        VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).awaitRefreshQueue();
        Collection<FilePath> collection = this.getUntrackedFilePaths();
        if (collection == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    GitRepositoryIgnoredFilesHolder getIgnoredFilesHolder() {
        MyGitRepositoryIgnoredFilesHolder myGitRepositoryIgnoredFilesHolder = this.myIgnoredFilesHolder;
        if (myGitRepositoryIgnoredFilesHolder == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(9);
        }
        return myGitRepositoryIgnoredFilesHolder;
    }

    @ApiStatus.Internal
    public boolean isInitialized() {
        return this.myUntrackedFiles.getInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myEverythingDirty || !this.myDirtyFiles.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isDirty()) {
                return;
            }
            this.myInUpdate = true;
        }
        ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
        this.myQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)new ComparableObject.Impl(new Object[]{this, "update"}), this::update));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ArrayList<FilePath> dirtyFiles;
        boolean nothingToDo;
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = nothingToDo = !this.isDirty();
            if (nothingToDo) {
                this.myInUpdate = false;
            }
            dirtyFiles = this.myEverythingDirty ? null : new ArrayList<FilePath>(this.myDirtyFiles);
            this.myDirtyFiles.clear();
            this.myEverythingDirty = false;
        }
        if (nothingToDo) {
            ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
            return;
        }
        ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).progressStarted();
        try {
            Set<FilePath> newIgnored;
            Set<FilePath> oldIgnored;
            boolean everythingDirty = dirtyFiles == null || dirtyFiles.contains(VcsUtil.getFilePath((VirtualFile)this.myRoot));
            StructuredIdeActivity activity = GitRefreshUsageCollector.logUntrackedRefresh(this.myProject, everythingDirty);
            RefreshResult result2 = this.refreshFiles(dirtyFiles);
            activity.finished();
            this.removePathsUnderOtherRoots(result2.untracked, "unversioned");
            this.removePathsUnderOtherRoots(result2.ignored, "ignored");
            RecursiveFilePathSet dirtyScope = null;
            if (dirtyFiles != null) {
                dirtyScope = new RecursiveFilePathSet(this.myRoot.isCaseSensitive());
                dirtyScope.addAll(dirtyFiles);
            }
            Object object2 = this.LOCK;
            synchronized (object2) {
                oldIgnored = this.myIgnoredFilesHolder.getIgnoredFilePaths();
                this.applyRefreshResult(result2, dirtyScope, oldIgnored);
                newIgnored = this.myIgnoredFilesHolder.getIgnoredFilePaths();
                this.myInUpdate = this.isDirty();
            }
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).repositoryUpdated(this.myRepository);
            ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
            ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
            ((IgnoredToExcludedSynchronizer)this.myProject.getService(IgnoredToExcludedSynchronizer.class)).onIgnoredFilesUpdate(newIgnored, oldIgnored);
        }
        finally {
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitRefreshListener.TOPIC)).progressStopped();
        }
    }

    private void applyRefreshResult(@NotNull RefreshResult result2, @Nullable RecursiveFilePathSet dirtyScope, @NotNull Set<FilePath> oldIgnored) {
        if (result2 == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(10);
        }
        if (oldIgnored == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(11);
        }
        RecursiveFilePathSet newIgnored = new RecursiveFilePathSet(this.myRoot.isCaseSensitive());
        RecursiveFilePathSet newUntracked = new RecursiveFilePathSet(this.myRoot.isCaseSensitive());
        if (dirtyScope != null) {
            Set<FilePath> untrackedSet = this.myUntrackedFiles.toSet();
            untrackedSet.removeIf(filePath -> dirtyScope.hasAncestor(filePath));
            untrackedSet.addAll(result2.untracked);
            newUntracked.addAll(untrackedSet);
            for (FilePath filePath2 : oldIgnored) {
                if (dirtyScope.hasAncestor(filePath2)) continue;
                newIgnored.add(filePath2);
            }
            for (FilePath filePath2 : result2.ignored) {
                if (newIgnored.hasAncestor(filePath2)) continue;
                newIgnored.add(filePath2);
            }
        } else {
            newUntracked.addAll(result2.untracked);
            newIgnored.addAll(result2.ignored);
        }
        this.myIgnoredFilesHolder.ignoredFiles.set(newIgnored);
        this.myUntrackedFiles.set(newUntracked);
    }

    private void removePathsUnderOtherRoots(@NotNull Collection<FilePath> untrackedFiles, @NonNls String type) {
        if (untrackedFiles == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(12);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        int removedFiles = 0;
        int maxFilesToReport = 10;
        Iterator<FilePath> it = untrackedFiles.iterator();
        while (it.hasNext()) {
            FilePath filePath = it.next();
            VirtualFile root = vcsManager.getVcsRootFor(filePath);
            if (this.myRoot.equals(root)) continue;
            it.remove();
            if (++removedFiles >= maxFilesToReport) continue;
            LOG.debug(String.format("Ignoring %s file under another root: %s; root: %s; mapped root: %s", type, filePath.getPresentableUrl(), this.myRoot.getPresentableUrl(), root != null ? root.getPresentableUrl() : "null"));
        }
        if (removedFiles >= maxFilesToReport) {
            LOG.debug(String.format("Ignoring %s files under another root: %s files total", type, removedFiles));
        }
    }

    @NotNull
    private RefreshResult refreshFiles(@Nullable List<FilePath> dirty) {
        RefreshResult refreshResult;
        try {
            boolean withIgnored = AdvancedSettings.getBoolean((String)"vcs.process.ignored");
            List<LightFileStatus.StatusRecord> fileStatuses = GitIndexStatusUtilKt.getFileStatus(this.myProject, this.myRoot, ContainerUtil.notNullize(dirty), false, true, withIgnored);
            RefreshResult result2 = new RefreshResult();
            for (LightFileStatus.StatusRecord status : fileStatuses) {
                if (GitIndexStatusUtilKt.isUntracked(status.getIndex())) {
                    result2.untracked.add(GitUntrackedFilesHolder.getFilePath(this.myRoot, status));
                }
                if (!GitIndexStatusUtilKt.isIgnored(status.getIndex())) continue;
                result2.ignored.add(GitUntrackedFilesHolder.getFilePath(this.myRoot, status));
            }
            refreshResult = result2;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return new RefreshResult();
        }
        if (refreshResult == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(13);
        }
        return refreshResult;
    }

    @NotNull
    private static FilePath getFilePath(@NotNull VirtualFile root, @NotNull LightFileStatus.StatusRecord status) {
        if (root == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(14);
        }
        if (status == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(15);
        }
        String path = status.getPath();
        FilePath filePath = GitContentRevision.createPath(root, path, path.endsWith("/"));
        if (filePath == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(16);
        }
        return filePath;
    }

    @TestOnly
    public Waiter createWaiter() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return new Waiter(this.myQueue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldIgnored";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedFiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUntrackedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUntrackedFilePaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUntrackedFilePaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesHolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addUntracked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeUntracked";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markPossiblyUntracked";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsUntrackedFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyRefreshResult";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removePathsUnderOtherRoots";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9, 13, 16 -> new IllegalStateException(string);
        };
    }

    private class MyGitRepositoryIgnoredFilesHolder
    extends GitRepositoryIgnoredFilesHolder {
        @NotNull
        private final CopyOnWriteFilePathSet ignoredFiles;

        private MyGitRepositoryIgnoredFilesHolder() {
            this.ignoredFiles = new CopyOnWriteFilePathSet(GitUntrackedFilesHolder.this.myRoot.isCaseSensitive());
        }

        @Override
        public boolean getInitialized() {
            return this.ignoredFiles.getInitialized();
        }

        @Override
        @NotNull
        public Set<FilePath> getIgnoredFilePaths() {
            Set<FilePath> set = this.ignoredFiles.toSet();
            if (set == null) {
                MyGitRepositoryIgnoredFilesHolder.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        public boolean isInUpdateMode() {
            return GitUntrackedFilesHolder.this.isInUpdateMode();
        }

        @Override
        public boolean containsFile(@NotNull FilePath file) {
            if (file == null) {
                MyGitRepositoryIgnoredFilesHolder.$$$reportNull$$$0(1);
            }
            return this.ignoredFiles.hasAncestor(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeIgnoredFiles(@NotNull Collection<? extends FilePath> filePaths) {
            if (filePaths == null) {
                MyGitRepositoryIgnoredFilesHolder.$$$reportNull$$$0(2);
            }
            Object object = GitUntrackedFilesHolder.this.LOCK;
            synchronized (object) {
                this.ignoredFiles.remove(filePaths);
                if (!GitUntrackedFilesHolder.this.myEverythingDirty) {
                    if (ContainerUtil.exists(filePaths, this.ignoredFiles::hasAncestor)) {
                        GitUntrackedFilesHolder.this.myEverythingDirty = true;
                    } else {
                        GitUntrackedFilesHolder.this.myDirtyFiles.addAll(filePaths);
                    }
                }
            }
            ChangeListManagerImpl.getInstanceImpl((Project)GitUntrackedFilesHolder.this.myProject).notifyUnchangedFileStatusChanged();
        }

        private void clear() {
            this.ignoredFiles.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/repo/GitUntrackedFilesHolder$MyGitRepositoryIgnoredFilesHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredFilePaths";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/repo/GitUntrackedFilesHolder$MyGitRepositoryIgnoredFilesHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "containsFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeIgnoredFiles";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RefreshResult {
        @NotNull
        public final Set<FilePath> untracked = new HashSet<FilePath>();
        @NotNull
        public final Set<FilePath> ignored = new HashSet<FilePath>();

        private RefreshResult() {
        }
    }

    @TestOnly
    public static class Waiter {
        private final MergingUpdateQueue myQueue;

        public Waiter(@NotNull MergingUpdateQueue queue) {
            if (queue == null) {
                Waiter.$$$reportNull$$$0(0);
            }
            this.myQueue = queue;
        }

        public void waitFor() {
            CountDownLatch waiter = new CountDownLatch(1);
            this.myQueue.queue(Update.create((Object)waiter, () -> waiter.countDown()));
            ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
            try {
                this.myQueue.waitForAllExecuted(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "git4idea/repo/GitUntrackedFilesHolder$Waiter", "<init>"));
        }
    }
}

