/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;

public class Maven3WorkspaceReader
implements MavenWorkspaceReader {
    private final WorkspaceRepository myRepository;
    private final WorkspaceReader myWorkspaceReader;
    private final Map<MavenId, Model> myMavenModelMap;

    public Maven3WorkspaceReader(@Nullable WorkspaceReader workspaceReader, @NotNull Map<MavenId, Model> mavenModelMap) {
        if (mavenModelMap == null) {
            Maven3WorkspaceReader.$$$reportNull$$$0(0);
        }
        this.myRepository = new WorkspaceRepository();
        this.myWorkspaceReader = workspaceReader;
        this.myMavenModelMap = mavenModelMap;
    }

    public WorkspaceRepository getRepository() {
        return this.myRepository;
    }

    public File findArtifact(Artifact artifact) {
        return this.myWorkspaceReader == null ? null : this.myWorkspaceReader.findArtifact(artifact);
    }

    public List<String> findVersions(Artifact artifact) {
        return this.myWorkspaceReader == null ? Collections.emptyList() : this.myWorkspaceReader.findVersions(artifact);
    }

    public Model findModel(Artifact artifact) {
        Model modelFromWorkspace;
        if (this.myWorkspaceReader instanceof MavenWorkspaceReader && (modelFromWorkspace = ((MavenWorkspaceReader)this.myWorkspaceReader).findModel(artifact)) != null) {
            return modelFromWorkspace;
        }
        return this.myMavenModelMap.get(new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenModelMap", "org/jetbrains/idea/maven/server/Maven3WorkspaceReader", "<init>"));
    }
}

