/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution.context.PersistentContext;
import javolution.context.Realtime;
import javolution.context.RealtimeObject;
import javolution.lang.Reusable;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastMap<K, V>
extends RealtimeObject
implements Map<K, V>,
Reusable,
Serializable {
    protected static final XMLFormat<FastMap> XML = new XMLFormat((Class)new FastMap().getClass()){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            FastComparator fastComparator;
            FastMap fastMap = (FastMap)object;
            fastMap.setShared(inputElement.getAttribute("shared", false));
            FastComparator fastComparator2 = (FastComparator)inputElement.get("KeyComparator");
            if (fastComparator2 != null) {
                fastMap.setKeyComparator(fastComparator2);
            }
            if ((fastComparator = (FastComparator)inputElement.get("ValueComparator")) != null) {
                fastMap.setValueComparator(fastComparator);
            }
            while (inputElement.hasNext()) {
                Object t = inputElement.get("Key");
                Object t2 = inputElement.get("Value");
                fastMap.put(t, t2);
            }
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            FastMap fastMap = (FastMap)object;
            if (fastMap.isShared()) {
                outputElement.setAttribute("shared", true);
            }
            if (fastMap.getKeyComparator() != FastComparator.DEFAULT) {
                outputElement.add(fastMap.getKeyComparator(), "KeyComparator");
            }
            if (fastMap.getValueComparator() != FastComparator.DEFAULT) {
                outputElement.add(fastMap.getValueComparator(), "ValueComparator");
            }
            FastCollection.Record record = fastMap.head();
            Entry entry = fastMap.tail();
            while ((record = ((Entry)record).getNext()) != entry) {
                outputElement.add(((Entry)record).getKey(), "Key");
                outputElement.add(((Entry)record).getValue(), "Value");
            }
        }
    };
    private static final int R0 = 5;
    private static final int M0 = 31;
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastMap();
        }

        public void cleanup(Object object) {
            ((FastMap)object).reset();
        }
    };
    private transient Entry<K, V>[][] _entries;
    private transient Entry<K, V> _head = new Entry();
    private transient Entry<K, V> _tail = new Entry();
    private transient int _size;
    private transient Values _values = new Values();
    private transient KeySet _keySet = new KeySet();
    private transient EntrySet _entrySet = new EntrySet();
    private transient Map<K, V> _unmodifiable = new Unmodifiable();
    private transient FastMap<K, V> _oldEntries;
    private transient FastComparator _keyComparator = FastComparator.DEFAULT;
    private transient FastComparator _keyComp = FastComparator._Rehash ? FastComparator.REHASH : null;
    private transient boolean _isShared;
    private static final Entry[] NULL_BLOCK = new Entry[32];

    public FastMap() {
        this(4);
    }

    public FastMap(String string) {
        this();
        new PersistentContext.Reference(string, this){

            protected void notifyValueChange() {
                FastMap.this.clear();
                FastMap.this.putAll((FastMap)this.get());
            }
        };
    }

    public FastMap(int n) {
        int n2;
        for (n2 = 32; n2 < n; n2 <<= 1) {
        }
        this._entries = new Entry[n2 >> 5][];
        int n3 = 0;
        while (n3 < this._entries.length) {
            this._entries[n3++] = new Entry[32];
        }
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        Entry<K, V> entry = this._tail;
        int n4 = 0;
        while (n4++ < n) {
            Entry entry2 = new Entry();
            entry2._previous = (Entry)entry;
            ((Entry)entry)._next = entry2;
            entry = entry2;
        }
    }

    public FastMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    private FastMap(Entry<K, V>[][] entryArray) {
        this._entries = entryArray;
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
    }

    public static <K, V> FastMap<K, V> newInstance() {
        return (FastMap)FACTORY.object();
    }

    public final Entry<K, V> head() {
        return this._head;
    }

    public final Entry<K, V> tail() {
        return this._tail;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final boolean isEmpty() {
        return ((Entry)this._head)._next == this._tail;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public final boolean containsValue(Object object) {
        return this._values.contains(object);
    }

    @Override
    public final V get(Object object) {
        Entry<K, V> entry = this.getEntry(object, this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object));
        return (V)(entry != null ? ((Entry)entry)._value : null);
    }

    public final Entry<K, V> getEntry(Object object) {
        return this.getEntry(object, this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object));
    }

    @Override
    public final V put(K k, V v) {
        int n;
        int n2 = n = this._keyComp == null ? k.hashCode() : this._keyComp.hashCodeOf(k);
        if (this._isShared) {
            return this.putShared(k, v, n);
        }
        Entry<K, V> entry = this.getEntry(k, n);
        if (entry == null) {
            this.addEntry(n, k, v);
            return null;
        }
        Object object = ((Entry)entry)._value;
        ((Entry)entry)._value = v;
        return (V)object;
    }

    private synchronized V putShared(K k, V v, int n) {
        Entry<K, V> entry = this.getEntry(k, n);
        if (entry == null) {
            this.addEntry(n, k, v);
            return null;
        }
        Object object = ((Entry)entry)._value;
        ((Entry)entry)._value = v;
        return (V)object;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        if (map instanceof FastMap) {
            FastMap fastMap = (FastMap)map;
            Entry entry = fastMap._head;
            Entry<K, V> entry2 = fastMap._tail;
            while ((entry = entry._next) != entry2) {
                this.put(entry._key, entry._value);
            }
        } else {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public final V remove(Object object) {
        if (this._isShared) {
            return this.removeShared(object);
        }
        Entry<K, V> entry = this.getEntry(object);
        if (entry != null) {
            Object object2 = ((Entry)entry)._value;
            this.removeEntry(entry);
            return (V)object2;
        }
        return null;
    }

    private synchronized V removeShared(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        if (entry != null) {
            --this._size;
            ((Entry)entry).detach();
            return (V)((Entry)entry)._value;
        }
        return null;
    }

    public FastMap<K, V> setShared(boolean bl) {
        this._isShared = bl;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FastMap<K, V> setKeyComparator(FastComparator fastComparator) {
        this._keyComparator = fastComparator;
        this._keyComp = fastComparator == FastComparator.DEFAULT ? (FastComparator._Rehash ? FastComparator.REHASH : null) : (fastComparator == FastComparator.DIRECT ? null : fastComparator);
        return this;
    }

    public FastComparator getKeyComparator() {
        return this._keyComparator;
    }

    public FastMap<K, V> setValueComparator(FastComparator fastComparator) {
        this._values.setValueComparator(fastComparator);
        return this;
    }

    public FastComparator getValueComparator() {
        return this._values.getValueComparator();
    }

    @Override
    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            entry._key = null;
            entry._value = null;
            Entry[][] entryArray = entry._table;
            entryArray[((Entry)entry)._keyHash >> 5 & entryArray.length - 1][((Entry)entry)._keyHash & 0x1F] = null;
        }
        this._tail = ((Entry)this._head)._next;
        this._size = 0;
        this._oldEntries = null;
    }

    private synchronized void clearShared() {
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            Entry[][] entryArray = entry._table;
            entryArray[((Entry)entry)._keyHash >> 5 & entryArray.length - 1][((Entry)entry)._keyHash & 0x1F] = null;
        }
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        this._oldEntries = null;
        this._size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() == map.size()) {
                Set set = map.entrySet();
                Entry entry = this._head;
                Entry<K, V> entry2 = this._tail;
                while ((entry = entry._next) != entry2) {
                    if (set.contains(entry)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            n += entry.hashCode();
        }
        return n;
    }

    @Override
    public Text toText() {
        return this._entrySet.toText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream printStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this._entries.length; ++i) {
            for (int j = 0; j < this._entries[i].length; ++j) {
                Entry entry = this._entries[i][j];
                int n4 = 0;
                while (entry != null) {
                    if (++n4 > n) {
                        n = n4;
                    }
                    if (n4 > 1) {
                        ++n2;
                    }
                    entry = entry._beside;
                    ++n3;
                }
            }
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        if (n3 != 0) {
            textBuilder.append(100 * n2 / n3);
            textBuilder.append('%');
        } else {
            textBuilder.append("N/A");
        }
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.print("SIZE: " + n3);
            printStream.print(", TABLE LENGTH: " + this._entries.length * this._entries[0].length);
            printStream.print(", AVG COLLISIONS: " + textBuilder);
            printStream.print(", MAX SLOT OCCUPANCY: " + n);
            printStream.print(", KEY COMPARATOR: " + (this._keyComp == null ? FastComparator.DIRECT : this._keyComp));
            printStream.print(", SHARED: " + this._isShared);
            printStream.println();
            if (this._oldEntries != null) {
                printStream.print(" + ");
                this._oldEntries.printStatistics(printStream);
            }
        }
    }

    @Override
    public final Collection<V> values() {
        return this._values;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    @Override
    public final Set<K> keySet() {
        return this._keySet;
    }

    public final Map<K, V> unmodifiable() {
        return this._unmodifiable;
    }

    private final Entry<K, V> getEntry(Object object, int n) {
        Entry entry = this._entries[n >> 5 & this._entries.length - 1][n & 0x1F];
        while (entry != null) {
            if (object == entry._key || entry._keyHash == n && (this._keyComp == null ? object.equals(entry._key) : this._keyComp.areEqual(object, entry._key))) {
                return entry;
            }
            entry = entry._beside;
        }
        return this._oldEntries != null ? super.getEntry(object, n) : null;
    }

    private void addEntry(int n, K k, V v) {
        if (this._size++ >> 5 >= this._entries.length) {
            this.increaseEntryTable();
        }
        if (((Entry)this._tail)._next == null) {
            this.increaseCapacity();
        }
        Entry entry = ((Entry)this._tail)._next;
        ((Entry)this._tail)._key = k;
        ((Entry)this._tail)._value = v;
        ((Entry)this._tail)._keyHash = n;
        Entry.access$1002(this._tail, this._entries);
        int n2 = n >> 5 & this._entries.length - 1;
        Entry<K, V>[] entryArray = this._entries[n2];
        if (entryArray == NULL_BLOCK) {
            this.newBlock(n2);
            entryArray = this._entries[n2];
        }
        Entry<K, V> entry2 = entryArray[n & 0x1F];
        ((Entry)this._tail)._beside = (Entry)entry2;
        entryArray[n & 0x1F] = this._tail;
        this._tail = entry;
    }

    private final void removeEntry(Entry entry) {
        --this._size;
        entry._key = null;
        entry._value = null;
        entry.detach();
        Entry entry2 = ((Entry)this._tail)._next;
        entry._previous = (Entry)this._tail;
        entry._next = entry2;
        ((Entry)this._tail)._next = entry;
        if (entry2 != null) {
            entry2._previous = entry;
        }
    }

    private void newBlock(final int n) {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                ((FastMap)FastMap.this)._entries[n] = new Entry[32];
            }
        });
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                Entry entry = new Entry();
                FastMap.this._tail._next = entry;
                entry._previous = FastMap.this._tail;
                Entry entry2 = new Entry();
                entry._next = entry2;
                entry2._previous = entry;
                Entry entry3 = new Entry();
                entry2._next = entry3;
                entry3._previous = entry2;
                Entry entry4 = new Entry();
                entry3._next = entry4;
                entry4._previous = entry3;
            }
        });
    }

    private void increaseEntryTable() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                FastMap fastMap;
                int n = FastMap.this._entries.length << 3;
                if (n <= 8) {
                    fastMap = new FastMap(new Entry[8][]);
                } else if (n <= 64) {
                    fastMap = new FastMap(new Entry[64][]);
                } else if (n <= 512) {
                    fastMap = new FastMap(new Entry[512][]);
                } else if (n <= 4096) {
                    fastMap = new FastMap(new Entry[4096][]);
                } else if (n <= 32768) {
                    fastMap = new FastMap(new Entry[32768][]);
                } else if (n <= 262144) {
                    fastMap = new FastMap(new Entry[262144][]);
                } else if (n <= 0x200000) {
                    fastMap = new FastMap(new Entry[0x200000][]);
                } else if (n <= 0x1000000) {
                    fastMap = new FastMap(new Entry[0x1000000][]);
                } else if (n <= 0x8000000) {
                    fastMap = new FastMap(new Entry[0x8000000][]);
                } else {
                    return;
                }
                int n2 = 0;
                while (n2 < fastMap._entries.length) {
                    fastMap._entries[n2++] = NULL_BLOCK;
                }
                Entry[][] entryArray = fastMap._entries;
                FastMap.access$1602(fastMap, FastMap.this._entries);
                fastMap._oldEntries = FastMap.this._oldEntries;
                fastMap._keyComp = FastMap.this._keyComp;
                fastMap._head = null;
                fastMap._tail = null;
                fastMap._size = -1;
                FastMap.this._oldEntries = fastMap;
                FastMap.access$1602(FastMap.this, entryArray);
            }
        });
    }

    @Override
    public boolean move(Realtime.ObjectSpace objectSpace) {
        if (super.move(objectSpace)) {
            Entry entry = this._head;
            Entry<K, V> entry2 = this._tail;
            while ((entry = entry._next) != entry2) {
                if (entry._key instanceof Realtime) {
                    ((Realtime)entry._key).move(objectSpace);
                }
                if (!(entry._value instanceof Realtime)) continue;
                ((Realtime)entry._value).move(objectSpace);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.setShared(false);
        this.clear();
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this._entries = new Entry[n2][];
        int n3 = 0;
        while (n3 < this._entries.length) {
            this._entries[n3++] = NULL_BLOCK;
        }
        this._head = new Entry();
        this._tail = new Entry();
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._unmodifiable = new Unmodifiable();
        this.setShared(objectInputStream.readBoolean());
        this.setKeyComparator((FastComparator)objectInputStream.readObject());
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        for (n3 = 0; n3 < n; ++n3) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.addEntry(this._keyComparator.hashCodeOf(object), object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._size);
        objectOutputStream.writeInt(this._entries.length);
        objectOutputStream.writeBoolean(this._isShared);
        objectOutputStream.writeObject(this._keyComparator);
        objectOutputStream.writeObject(this._values.getValueComparator());
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            objectOutputStream.writeObject(entry._key);
            objectOutputStream.writeObject(entry._value);
        }
    }

    static /* synthetic */ Entry[][] access$1602(FastMap fastMap, Entry[][] entryArray) {
        fastMap._entries = entryArray;
        return entryArray;
    }

    private final class Unmodifiable
    extends RealtimeObject
    implements Map,
    Serializable {
        private Unmodifiable() {
        }

        public boolean equals(Object object) {
            return FastMap.this.equals(object);
        }

        public int hashCode() {
            return FastMap.this.hashCode();
        }

        public Text toText() {
            return FastMap.this.toText();
        }

        public int size() {
            return FastMap.this.size();
        }

        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        public boolean containsKey(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return FastMap.this.containsValue(object);
        }

        public Object get(Object object) {
            return FastMap.this.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Set keySet() {
            return (Set)FastMap.this._keySet.unmodifiable();
        }

        public Collection values() {
            return FastMap.this._values.unmodifiable();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry<K, V>
    implements Map.Entry<K, V>,
    FastCollection.Record {
        private Entry<K, V> _next;
        private Entry<K, V> _previous;
        private K _key;
        private V _value;
        private Entry<K, V> _beside;
        private Entry<K, V>[][] _table;
        private int _keyHash;

        private Entry() {
        }

        @Override
        public final Entry<K, V> getNext() {
            return this._next;
        }

        @Override
        public final Entry<K, V> getPrevious() {
            return this._previous;
        }

        @Override
        public final K getKey() {
            return this._key;
        }

        @Override
        public final V getValue() {
            return this._value;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this._value;
            this._value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        private final void detach() {
            this._previous._next = this._next;
            this._next._previous = this._previous;
            int n = this._keyHash >> 5 & this._table.length - 1;
            Entry<K, V> entry = this._beside;
            Entry<K, V> entry2 = this._table[n][this._keyHash & 0x1F];
            if (entry2 == this) {
                this._table[n][this._keyHash & 0x1F] = entry;
            } else {
                while (entry2._beside != this) {
                    entry2 = entry2._beside;
                }
                entry2._beside = entry;
            }
        }

        static /* synthetic */ Entry[][] access$1002(Entry entry, Entry[][] entryArray) {
            entry._table = entryArray;
            return entryArray;
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private KeySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._key;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private EntrySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry = (Entry)object;
                Entry entry2 = FastMap.this.getEntry(entry.getKey());
                return ((Object)entry).equals(entry2);
            }
            return false;
        }

        public Text toText() {
            Text text = Text.valueOf('[');
            Text text2 = Text.valueOf('=');
            Text text3 = Text.valueOf(", ");
            Entry entry = FastMap.this._head;
            Entry entry2 = FastMap.this._tail;
            while ((entry = entry._next) != entry2) {
                text = text.concat(Text.valueOf(entry._key)).concat(text2).concat(Text.valueOf(entry._value));
                if (entry._next == entry2) continue;
                text = text.concat(text3);
            }
            return text.concat(Text.valueOf(']'));
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return (Map.Entry)((Object)record);
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class Values
    extends FastCollection {
        private Values() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._value;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }
}

