/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.annotations.NotFoundAction;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.entity.AbstractEntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;

public class EntityResultImpl
extends AbstractEntityResultGraphNode
implements EntityResult,
InitializerProducer<EntityResultImpl> {
    private final TableGroup tableGroup;
    private final String resultVariable;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, TableGroup tableGroup, String resultVariable) {
        super(entityValuedModelPart, navigablePath);
        this.tableGroup = tableGroup;
        this.resultVariable = resultVariable;
    }

    @Override
    public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        if (fetchable instanceof TableGroupProducer) {
            for (TableGroupJoin tableGroupJoin : this.tableGroup.getTableGroupJoins()) {
                NavigablePath navigablePath = tableGroupJoin.getNavigablePath();
                if (!tableGroupJoin.getJoinedGroup().isFetched() || !fetchable.getFetchableName().equals(navigablePath.getLocalName()) || tableGroupJoin.getJoinedGroup().getModelPart() != fetchable || !NullnessUtil.castNonNull(navigablePath.getParent()).equals(this.getNavigablePath())) continue;
                return navigablePath;
            }
        }
        return super.resolveNavigablePath(fetchable);
    }

    @Override
    public FetchableContainer getReferencedMappingType() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public EntityValuedModelPart getReferencedModePart() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    protected String getSourceAlias() {
        return this.tableGroup.getSourceAlias();
    }

    public DomainResultAssembler createResultAssembler(InitializerParent parent, AssemblerCreationState creationState) {
        return new EntityAssembler(this.getResultJavaType(), creationState.resolveInitializer(this, parent, this).asEntityInitializer());
    }

    @Override
    public Initializer<?> createInitializer(EntityResultImpl resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer(parent, creationState);
    }

    @Override
    public Initializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EntityInitializerImpl(this, this.getSourceAlias(), this.getIdentifierFetch(), this.getDiscriminatorFetch(), null, this.getRowIdResult(), NotFoundAction.EXCEPTION, false, null, true, creationState);
    }

    public String toString() {
        return "EntityResultImpl {" + this.getNavigablePath() + "}";
    }
}

