/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics.gauge;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.RubyHash;
import org.logstash.ext.JrubyTimestampExtLibrary;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.MetricType;
import org.logstash.instrument.metrics.gauge.BooleanGauge;
import org.logstash.instrument.metrics.gauge.GaugeMetric;
import org.logstash.instrument.metrics.gauge.NumberGauge;
import org.logstash.instrument.metrics.gauge.RubyHashGauge;
import org.logstash.instrument.metrics.gauge.RubyTimeStampGauge;
import org.logstash.instrument.metrics.gauge.TextGauge;
import org.logstash.instrument.metrics.gauge.UnknownGauge;

public class LazyDelegatingGauge
extends AbstractMetric<Object>
implements GaugeMetric<Object, Object> {
    private static final Logger LOGGER = LogManager.getLogger(LazyDelegatingGauge.class);
    protected final String key;
    private GaugeMetric lazyMetric;

    public LazyDelegatingGauge(String key) {
        this(key, null);
    }

    public LazyDelegatingGauge(String key, Object initialValue) {
        super(key);
        this.key = key;
        if (initialValue != null) {
            this.wakeMetric(initialValue);
        }
    }

    @Override
    public Object get() {
        return this.lazyMetric == null ? null : this.lazyMetric.get();
    }

    public Optional getMetric() {
        return Optional.ofNullable(this.lazyMetric);
    }

    @Override
    public MetricType getType() {
        return this.lazyMetric == null ? null : this.lazyMetric.getType();
    }

    @Override
    public Object getValue() {
        return this.lazyMetric == null ? null : this.lazyMetric.getValue();
    }

    @Override
    public void set(Object value) {
        if (this.lazyMetric == null) {
            this.wakeMetric(value);
        } else {
            this.lazyMetric.set(value);
        }
    }

    private synchronized void wakeMetric(Object value) {
        if (this.lazyMetric == null && value != null) {
            if (value instanceof String) {
                this.lazyMetric = new TextGauge(this.key, (String)value);
            } else if (value instanceof Number) {
                this.lazyMetric = new NumberGauge(this.key, (Number)value);
            } else if (value instanceof Boolean) {
                this.lazyMetric = new BooleanGauge(this.key, (Boolean)value);
            } else if (value instanceof RubyHash) {
                this.lazyMetric = new RubyHashGauge(this.key, (RubyHash)value);
            } else if (value instanceof JrubyTimestampExtLibrary.RubyTimestamp) {
                this.lazyMetric = new RubyTimeStampGauge(this.key, (JrubyTimestampExtLibrary.RubyTimestamp)((Object)value));
            } else {
                LOGGER.warn("A gauge metric of an unknown type ({}) has been created for key: {}. This may result in invalid serialization.  It is recommended to log an issue to the responsible developer/development team.", (Object)value.getClass().getCanonicalName(), (Object)this.key);
                this.lazyMetric = new UnknownGauge(this.key, value);
            }
        }
    }
}

