/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(0.0lf, -1.0lf) => 0.0lf
 * reflect(0.0lf, 1.0lf) => 0.0lf
 * reflect(-1.3333333333333333lf, -1.0lf) => 1.3333333333333333lf
 * reflect(-1.3333333333333333lf, 1.0lf) => 1.3333333333333333lf
 * reflect(0.85lf, -1.0lf) => -0.85lf
 * reflect(0.85lf, 1.0lf) => -0.85lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(reflect(0.0lf, -1.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance(reflect(0.0lf, 1.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array1;
  double[distance(reflect(-1.3333333333333333lf, -1.0lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array2;
  double[distance(reflect(-1.3333333333333333lf, 1.0lf), 1.3333333333333333lf) <= 1.3333333333333333e-05lf ? 1 : -1] array3;
  double[distance(reflect(0.85lf, -1.0lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array4;
  double[distance(reflect(0.85lf, 1.0lf), -0.85lf) <= 8.5e-06lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
