/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.timeseries.util.ParseUtils;

public class CrossClusterConfigUtils {
    private static final Logger logger = LogManager.getLogger(ParseUtils.class);

    public static Client getClientForCluster(String clusterName, Client client, String localClusterName) {
        return clusterName.equals(localClusterName) ? client : client.getRemoteClusterClient(clusterName);
    }

    public static Client getClientForCluster(String clusterName, Client client, ClusterService clusterService) {
        return CrossClusterConfigUtils.getClientForCluster(clusterName, client, clusterService.getClusterName().value());
    }

    public static HashMap<String, List<String>> separateClusterIndexes(List<String> indexes, ClusterService clusterService) {
        return CrossClusterConfigUtils.separateClusterIndexes(indexes, clusterService.getClusterName().value());
    }

    public static HashMap<String, List<String>> separateClusterIndexes(List<String> indexes, String localClusterName) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        for (String index : indexes) {
            Pair<String, String> clusterAndIndex = CrossClusterConfigUtils.parseClusterAndIndexName(index);
            String clusterName = (String)clusterAndIndex.getKey();
            String indexName = (String)clusterAndIndex.getValue();
            if (clusterName.isEmpty()) {
                clusterName = localClusterName;
            }
            output.computeIfAbsent(clusterName, k -> new ArrayList()).add(indexName);
        }
        return output;
    }

    public static Pair<String, String> parseClusterAndIndexName(String index) {
        if (index.contains(":")) {
            String[] parts = index.split(":", 2);
            String clusterName = parts[0];
            String indexName = parts.length > 1 ? parts[1] : "";
            return Pair.of((Object)clusterName, (Object)indexName);
        }
        return Pair.of((Object)"", (Object)index);
    }
}

