/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsHierarchicalKeyring_Compile.HierarchyUnwrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyUnwrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.int64;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
    public DecryptionMaterials _materials = null;
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Character> _branchKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public long _ttlSeconds = 0L;
    public ICryptographicMaterialsCache _cache = null;
    public DafnySequence<? extends Byte> _partitionIdBytes = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _logicalKeyStoreNameBytes = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, IKeyStoreClient keyStore, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Character> branchKeyId, long ttlSeconds, ICryptographicMaterialsCache cache, DafnySequence<? extends Byte> partitionIdBytes, DafnySequence<? extends Byte> logicalKeyStoreNameBytes) {
        this._materials = materials;
        this._keyStore = keyStore;
        this._cryptoPrimitives = cryptoPrimitives;
        this._branchKeyId = branchKeyId;
        this._ttlSeconds = ttlSeconds;
        this._cache = cache;
        this._partitionIdBytes = partitionIdBytes;
        this._logicalKeyStoreNameBytes = logicalKeyStoreNameBytes;
    }

    @Override
    public Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out3;
        Result<AtomicPrimitivesClient, Error> _out2;
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _0_valueOrError0 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider info for Hierarchical Keyring")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _1_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _2_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _3_branchKeyIdUtf8 = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _4_ciphertext = edk.dtor_ciphertext();
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _5_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _5_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_4_ciphertext, _1_suite);
        if (_5_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _6_providerWrappedMaterial = _5_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _7_valueOrError2 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _7_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_6_providerWrappedMaterial.length()).compareTo(BigInteger.valueOf(__default.EDK__CIPHERTEXT__VERSION__INDEX())) >= 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received EDK Ciphertext of incorrect length.")));
        if (_7_valueOrError2.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _7_valueOrError2.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _8_branchKeyVersionUuid = _6_providerWrappedMaterial.subsequence(__default.EDK__CIPHERTEXT__BRANCH__KEY__VERSION__INDEX(), __default.EDK__CIPHERTEXT__VERSION__INDEX());
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _9_valueOrError3 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _9_valueOrError3 = UUID.__default.FromByteArray((DafnySequence<? extends Byte>)_8_branchKeyVersionUuid).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_9_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _9_valueOrError3.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _10_version = _9_valueOrError3.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _11_valueOrError4 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out0 = this.GetVersionCacheId(_3_branchKeyIdUtf8, (DafnySequence<? extends Character>)_10_version, this.cryptoPrimitives());
        _11_valueOrError4 = _out0;
        if (_11_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _11_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _12_cacheId = _11_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _13_valueOrError5 = Result.Default(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out1 = this.GetHierarchicalMaterialsVersion(this.branchKeyId(), _3_branchKeyIdUtf8, (DafnySequence<? extends Character>)_10_version, (DafnySequence<? extends Byte>)_12_cacheId);
        _13_valueOrError5 = _out1;
        if (_13_valueOrError5.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _13_valueOrError5.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _14_hierarchicalMaterials = _13_valueOrError5.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _15_branchKey = _14_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _16_branchKeyVersion = _14_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _17_valueOrError6 = Result.Default(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _17_valueOrError6 = UTF8.__default.Decode(_16_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_17_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _17_valueOrError6.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _18_branchKeyVersionAsString = _17_valueOrError6.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _19_valueOrError7 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _19_valueOrError7 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_18_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_19_valueOrError7.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _19_valueOrError7.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _20_branchKeyVersionAsBytes = _19_valueOrError7.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<AtomicPrimitivesClient, Error> _21_maybeCrypto = _out2 = software.amazon.cryptography.primitives.internaldafny.__default.AtomicPrimitives(software.amazon.cryptography.primitives.internaldafny.__default.DefaultCryptoConfig());
        Result<AtomicPrimitivesClient, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _22_valueOrError8 = null;
        _22_valueOrError8 = _21_maybeCrypto.MapFailure((TypeDescriptor<AtomicPrimitivesClient>)TypeDescriptor.reference(AtomicPrimitivesClient.class), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _23_e_boxed0 -> {
            Error _23_e = _23_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_23_e);
        });
        if (_22_valueOrError8.IsFailure((TypeDescriptor<AtomicPrimitivesClient>)TypeDescriptor.reference(AtomicPrimitivesClient.class), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _22_valueOrError8.PropagateFailure((TypeDescriptor<AtomicPrimitivesClient>)TypeDescriptor.reference(AtomicPrimitivesClient.class), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        IAwsCryptographicPrimitivesClient _24_cryptoPrimitivesX = _22_valueOrError8.Extract((TypeDescriptor<AtomicPrimitivesClient>)TypeDescriptor.reference(AtomicPrimitivesClient.class), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        AtomicPrimitivesClient _25_cryptoPrimitives = (AtomicPrimitivesClient)_24_cryptoPrimitivesX;
        KmsHierarchyUnwrapKeyMaterial _nw0 = new KmsHierarchyUnwrapKeyMaterial();
        _nw0.__ctor(_15_branchKey, _3_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_20_branchKeyVersionAsBytes, _25_cryptoPrimitives);
        KmsHierarchyUnwrapKeyMaterial _26_kmsHierarchyUnwrap = _nw0;
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _27_unwrapOutputRes = _out3 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(HierarchyUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _26_kmsHierarchyUnwrap);
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _28_valueOrError9 = Result.Default(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapEdkMaterialOutput.Default(HierarchyUnwrapInfo._typeDescriptor(), HierarchyUnwrapInfo.Default()));
        _28_valueOrError9 = _27_unwrapOutputRes;
        if (_28_valueOrError9.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _28_valueOrError9.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<HierarchyUnwrapInfo> _29_unwrapOutput = _28_valueOrError9.Extract(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _30_valueOrError10 = null;
        _30_valueOrError10 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _29_unwrapOutput.dtor_plaintextDataKey(), _29_unwrapOutput.dtor_symmetricSigningKey());
        if (_30_valueOrError10.IsFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _30_valueOrError10.PropagateFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _31_result = _30_valueOrError10.Extract(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _31_result);
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetVersionCacheId(DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> branchKeyVersion, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out0;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _0_valueOrError0 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed14 -> {
            DafnySequence _pat_let7_0 = boxed14;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let7_0, boxed15 -> {
                DafnySequence _1_branchKeyId = boxed15;
                return BigInteger.valueOf(_1_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_1_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _0_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DigestAlgorithm _2_hashAlgorithm = DigestAlgorithm.create_SHA__384();
        DafnySequence<? extends Byte> _3_resourceId = CacheConstants_Compile.__default.RESOURCE__ID__HIERARCHICAL__KEYRING();
        DafnySequence<? extends Byte> _4_scopeId = CacheConstants_Compile.__default.SCOPE__ID__DECRYPT();
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _5_valueOrError1 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _5_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.IsASCIIString(branchKeyVersion), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to represent as an ASCII string.")));
        if (_5_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _5_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _6_versionBytes = UTF8.__default.EncodeAscii(branchKeyVersion);
        DafnySequence _7_suffix = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(this.logicalKeyStoreNameBytes(), CacheConstants_Compile.__default.NULL__BYTE()), branchKeyIdUtf8), CacheConstants_Compile.__default.NULL__BYTE()), _6_versionBytes);
        DafnySequence _8_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_3_resourceId, CacheConstants_Compile.__default.NULL__BYTE()), _4_scopeId), CacheConstants_Compile.__default.NULL__BYTE()), this.partitionIdBytes()), CacheConstants_Compile.__default.NULL__BYTE()), (DafnySequence)_7_suffix);
        DigestInput _9_identifierDigestInput = DigestInput.create(_2_hashAlgorithm, (DafnySequence<? extends Byte>)_8_identifier);
        Result<DafnySequence<? extends Byte>, Error> _10_maybeCacheDigest = _out0 = Digest_Compile.__default.Digest(_9_identifierDigestInput);
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _11_valueOrError2 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _11_valueOrError2 = _10_maybeCacheDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _12_e_boxed0 -> {
            Error _12_e = _12_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_12_e);
        });
        if (_11_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _11_valueOrError2.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _13_cacheDigest = _11_valueOrError2.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _14_valueOrError3 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _14_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(_13_cacheDigest.length()), Digest_Compile.__default.Length(_2_hashAlgorithm)), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Digest generated a message not equal to the expected length.")));
        if (_14_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _14_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        cacheId = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _13_cacheDigest);
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetHierarchicalMaterialsVersion(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> version, DafnySequence<? extends Byte> cacheId) {
        long _out1;
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials.Default());
        GetCacheEntryInput _0_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None(int64._typeDescriptor()));
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out0 = this.cache().GetCacheEntry(_0_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1_getCacheOutput = _out0;
        if (_1_getCacheOutput.is_Failure() && !_1_getCacheOutput.dtor_error().is_EntryDoesNotExist()) {
            material = Result.create_Failure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1_getCacheOutput.dtor_error());
            return material;
        }
        long _2_now = _out1 = Time.__default.CurrentRelativeTime().longValue();
        if (_1_getCacheOutput.is_Failure() || !__default.cacheEntryWithinLimits(_1_getCacheOutput.dtor_value().dtor_creationTime(), _2_now, this.ttlSeconds())) {
            long _out3;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out2;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _3_maybeGetBranchKeyVersionOutput = _out2 = this.keyStore().GetBranchKeyVersion(GetBranchKeyVersionInput.create(branchKeyId, version));
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _4_valueOrError0 = Result.Default(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), GetBranchKeyVersionOutput.Default());
            _4_valueOrError0 = _3_maybeGetBranchKeyVersionOutput.MapFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _5_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _5_e = _5_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_5_e);
            });
            if (_4_valueOrError0.IsFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _4_valueOrError0.PropagateFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetBranchKeyVersionOutput _6_getBranchKeyVersionOutput = _4_valueOrError0.Extract(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _7_branchKeyMaterials = _6_getBranchKeyVersionOutput.dtor_branchKeyMaterials();
            long _8_now = _out3 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _9_valueOrError1 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            _9_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_8_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_9_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _9_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _10_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_7_branchKeyMaterials), _8_now, this.ttlSeconds() + _8_now, Option.create_None(PositiveInteger._typeDescriptor()), Option.create_None(PositiveInteger._typeDescriptor()));
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out4 = this.cache().PutCacheEntry(_10_putCacheEntryInput);
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _11_putResult = _out4;
            if (_11_putResult.is_Failure() && !_11_putResult.dtor_error().is_EntryAlreadyExists()) {
                material = Result.create_Failure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _11_putResult.dtor_error());
                return material;
            }
            material = Result.create_Success(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _7_branchKeyMaterials);
            return material;
        }
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _12_valueOrError2 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _12_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_1_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_1_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_12_valueOrError2.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _12_valueOrError2.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Character> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public ICryptographicMaterialsCache cache() {
        return this._cache;
    }

    public DafnySequence<? extends Byte> partitionIdBytes() {
        return this._partitionIdBytes;
    }

    public DafnySequence<? extends Byte> logicalKeyStoreNameBytes() {
        return this._logicalKeyStoreNameBytes;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring.DecryptSingleEncryptedDataKey";
    }
}

