/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.time.Instant;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.util.ParseUtils;

public class Config
implements ToXContentObject {
    private final String masterKey;
    private final Instant createTime;

    public Config(String masterKey, Instant createTime) {
        this.masterKey = masterKey;
        this.createTime = createTime;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field("master_key", this.masterKey);
        xContentBuilder.field("create_time", this.createTime.toEpochMilli());
        return xContentBuilder.endObject();
    }

    public static Config parse(XContentParser parser) throws IOException {
        String masterKey = null;
        Instant createTime = Instant.now();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "master_key": {
                    masterKey = parser.text();
                    continue block8;
                }
                case "create_time": {
                    createTime = ParseUtils.parseInstant(parser);
                    continue block8;
                }
            }
            throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a config object.", RestStatus.BAD_REQUEST);
        }
        if (masterKey == null) {
            throw new FlowFrameworkException("The config object requires a master key.", RestStatus.BAD_REQUEST);
        }
        return new Config(masterKey, createTime);
    }

    public String masterKey() {
        return this.masterKey;
    }

    public Instant createTime() {
        return this.createTime;
    }
}

