/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.flowframework.model.Template;

public class ReprovisionWorkflowRequest
extends ActionRequest {
    private String workflowId;
    private Template originalTemplate;
    private Template updatedTemplate;
    private TimeValue waitForCompletionTimeout;

    public ReprovisionWorkflowRequest(String workflowId, Template originalTemplate, Template updatedTemplate, TimeValue waitForCompletionTimeout) {
        this.workflowId = workflowId;
        this.originalTemplate = originalTemplate;
        this.updatedTemplate = updatedTemplate;
        this.waitForCompletionTimeout = waitForCompletionTimeout;
    }

    public ReprovisionWorkflowRequest(StreamInput in) throws IOException {
        super(in);
        this.workflowId = in.readString();
        this.originalTemplate = Template.parse(in.readString());
        this.updatedTemplate = Template.parse(in.readString());
        if (in.getVersion().onOrAfter(Version.V_2_19_0)) {
            this.waitForCompletionTimeout = in.readTimeValue();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.workflowId);
        out.writeString(this.originalTemplate.toJson());
        out.writeString(this.updatedTemplate.toJson());
        if (out.getVersion().onOrAfter(Version.V_2_19_0)) {
            out.writeTimeValue(this.waitForCompletionTimeout);
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public Template getOriginalTemplate() {
        return this.originalTemplate;
    }

    public Template getUpdatedTemplate() {
        return this.updatedTemplate;
    }

    public TimeValue getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }
}

