/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreElementType;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreTokenType;
import com.intellij.openapi.vcs.changes.ignore.psi.impl.IgnoreEntryDirectoryImpl;
import com.intellij.openapi.vcs.changes.ignore.psi.impl.IgnoreEntryFileImpl;
import com.intellij.openapi.vcs.changes.ignore.psi.impl.IgnoreEntryImpl;
import com.intellij.openapi.vcs.changes.ignore.psi.impl.IgnoreNegationImpl;
import com.intellij.openapi.vcs.changes.ignore.psi.impl.IgnoreSyntaxImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface IgnoreTypes {
    public static final IElementType ENTRY = new IgnoreElementType("ENTRY");
    public static final IElementType ENTRY_DIRECTORY = new IgnoreElementType("ENTRY_DIRECTORY");
    public static final IElementType ENTRY_FILE = new IgnoreElementType("ENTRY_FILE");
    public static final IElementType NEGATION = new IgnoreElementType("NEGATION");
    public static final IElementType SYNTAX = new IgnoreElementType("SYNTAX");
    public static final IElementType BRACKET_LEFT = new IgnoreTokenType("BRACKET_LEFT");
    public static final IElementType BRACKET_RIGHT = new IgnoreTokenType("BRACKET_RIGHT");
    public static final IElementType COMMENT = new IgnoreTokenType("COMMENT");
    public static final IElementType CRLF = new IgnoreTokenType("CRLF");
    public static final IElementType HEADER = new IgnoreTokenType("HEADER");
    public static final IElementType SECTION = new IgnoreTokenType("SECTION");
    public static final IElementType SLASH = new IgnoreTokenType("/");
    public static final IElementType SYNTAX_KEY = new IgnoreTokenType("syntax:");
    public static final IElementType VALUE = new IgnoreTokenType("VALUE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ENTRY) {
                return new IgnoreEntryImpl(node);
            }
            if (type == ENTRY_DIRECTORY) {
                return new IgnoreEntryDirectoryImpl(node);
            }
            if (type == ENTRY_FILE) {
                return new IgnoreEntryFileImpl(node);
            }
            if (type == NEGATION) {
                return new IgnoreNegationImpl(node);
            }
            if (type == SYNTAX) {
                return new IgnoreSyntaxImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

