/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.spi;

import java.util.Map;
import javax.measure.Dimension;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.quantity.QuantityDimension;
import tech.units.indriya.spi.StandardModel;

public abstract class DimensionalModel {
    private static DimensionalModel currentModel = new StandardModel();

    public static DimensionalModel current() {
        return currentModel;
    }

    protected static void setCurrent(DimensionalModel model) {
        currentModel = model;
    }

    protected DimensionalModel() {
    }

    public Dimension getFundamentalDimension(Dimension dimension) {
        Map<? extends Dimension, Integer> dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return dimension;
        }
        Dimension fundamentalProduct = QuantityDimension.NONE;
        for (Map.Entry<? extends Dimension, Integer> e : dimensions.entrySet()) {
            fundamentalProduct = fundamentalProduct.multiply(this.getFundamentalDimension(e.getKey())).pow(e.getValue());
        }
        return fundamentalProduct;
    }

    public AbstractConverter getDimensionalTransform(Dimension dimension) {
        Map<? extends Dimension, Integer> dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return AbstractConverter.IDENTITY;
        }
        AbstractConverter toFundamental = AbstractConverter.IDENTITY;
        for (Map.Entry<? extends Dimension, Integer> e : dimensions.entrySet()) {
            AbstractConverter cvtr = this.getDimensionalTransform(e.getKey());
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException("Non-linear dimensional transform");
            }
            int pow = e.getValue();
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                toFundamental = (AbstractConverter)toFundamental.concatenate(cvtr);
            }
        }
        return toFundamental;
    }
}

