/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonTemplateRunner;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class AddMethodQuickFix
implements LocalQuickFix {
    private final String myClassName;
    private final boolean myReplaceUsage;
    private final String myIdentifier;

    public AddMethodQuickFix(String identifier, String className, boolean replaceUsage) {
        this.myIdentifier = identifier;
        this.myClassName = className;
        this.myReplaceUsage = replaceUsage;
    }

    @NotNull
    public String getName() {
        String string = PyPsiBundle.message("QFIX.add.method.to.class", this.myIdentifier, this.myClassName);
        if (string == null) {
            AddMethodQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.add.method.to.class", new Object[0]);
        if (string == null) {
            AddMethodQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddMethodQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            AddMethodQuickFix.$$$reportNull$$$0(3);
        }
        try {
            PsiElement problemElement = descriptor2.getPsiElement();
            PyClassType type2 = AddMethodQuickFix.getClassType(problemElement);
            if (type2 == null) {
                return;
            }
            PyClass cls = type2.getPyClass();
            boolean callByClass = type2.isDefinition();
            PyStatementList clsStmtList = cls.getStatementList();
            PyUtil.sure(FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)clsStmtList));
            PyFunctionBuilder builder = new PyFunctionBuilder(this.myIdentifier, cls);
            PsiElement pe = problemElement.getParent();
            String decoratorName = null;
            PyExpression[] args = PyExpression.EMPTY_ARRAY;
            if (pe instanceof PyCallExpression) {
                PyPrefixExpression pyPrefixExpression;
                PyCallExpression callExpression = (PyCallExpression)pe;
                PyArgumentList arglist = callExpression.getArgumentList();
                if (arglist == null) {
                    return;
                }
                args = arglist.getArguments();
                PsiElement psiElement = callExpression.getParent();
                if (psiElement instanceof PyPrefixExpression && (pyPrefixExpression = (PyPrefixExpression)psiElement).getOperator() == PyTokenTypes.AWAIT_KEYWORD) {
                    builder.makeAsync();
                }
            }
            boolean madeInstance = false;
            if (callByClass) {
                TypeEvalContext context;
                PyType pyType;
                if (args.length > 0 && (pyType = (context = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile())).getType(args[0])) instanceof PyClassType && ((PyClassType)pyType).getPyClass().isSubclass(cls, context)) {
                    builder.parameter("self");
                    madeInstance = true;
                }
                if (!madeInstance) {
                    builder.parameter("cls");
                    decoratorName = "classmethod";
                }
            } else {
                builder.parameter("self");
            }
            boolean skipFirst = callByClass && madeInstance;
            for (PyExpression arg : args) {
                if (skipFirst) {
                    skipFirst = false;
                    continue;
                }
                if (arg instanceof PyKeywordArgument) {
                    builder.parameter(((PyKeywordArgument)arg).getKeyword());
                    continue;
                }
                if (arg instanceof PyReferenceExpression) {
                    PyReferenceExpression refex = (PyReferenceExpression)arg;
                    builder.parameter(refex.getReferencedName());
                    continue;
                }
                builder.parameter("param");
            }
            PyFunction pyFunction = builder.buildFunction();
            if (decoratorName != null) {
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                PyDecoratorList decoratorList = (PyDecoratorList)generator.createFromText(LanguageLevel.getDefault(), PyDecoratorList.class, "@" + decoratorName + "\ndef foo(): pass", new int[]{0, 0});
                pyFunction.addBefore((PsiElement)decoratorList, pyFunction.getFirstChild());
            }
            PyFunction pyFunction2 = (PyFunction)PyPsiRefactoringUtil.addElementToStatementList(pyFunction, clsStmtList, "__init__".equals(pyFunction.getName()));
            if (this.myReplaceUsage) {
                AddMethodQuickFix.showTemplateBuilder(pyFunction2);
            }
        }
        catch (IncorrectOperationException ignored) {
            PythonUiService.getInstance().showBalloonError(project, PyPsiBundle.message("QFIX.failed.to.add.method", new Object[0]));
        }
    }

    private static PyClassType getClassType(@NotNull PsiElement problemElement) {
        if (problemElement == null) {
            AddMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (problemElement instanceof PyQualifiedExpression) {
            PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
            if (qualifier == null) {
                return null;
            }
            PyType type2 = TypeEvalContext.userInitiated(problemElement.getProject(), problemElement.getContainingFile()).getType(qualifier);
            return type2 instanceof PyClassType ? (PyClassType)type2 : null;
        }
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyClass.class);
        return pyClass != null ? new PyClassTypeImpl(pyClass, false) : null;
    }

    private static void showTemplateBuilder(@NotNull PyFunction method) {
        PsiFile file;
        if (method == null) {
            AddMethodQuickFix.$$$reportNull$$$0(5);
        }
        if ((file = (method = (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method)).getContainingFile()) == null) {
            return;
        }
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)method);
        ParamHelper.walkDownParamArray(method.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        PyStatementList statementList = method.getStatementList();
        builder.replaceElement((PsiElement)statementList, "pass");
        PythonTemplateRunner.runTemplate(file, builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showTemplateBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

