/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.hierarchy.ChildrenFinderStrategy;
import org.assertj.swing.hierarchy.JDesktopPaneChildrenFinder;
import org.assertj.swing.hierarchy.JMenuChildrenFinder;
import org.assertj.swing.hierarchy.WindowChildrenFinder;

class ChildrenFinder {
    private static List<ChildrenFinderStrategy> strategies = Lists.newArrayList((Object[])new ChildrenFinderStrategy[]{new JDesktopPaneChildrenFinder(), new JMenuChildrenFinder(), new WindowChildrenFinder()});

    ChildrenFinder() {
    }

    @Nonnull
    @RunsInCurrentThread
    Collection<Component> childrenOf(@Nonnull Component c) {
        if (!(c instanceof Container)) {
            return Lists.emptyList();
        }
        Container container = (Container)c;
        ArrayList children = Lists.newArrayList((Object[])container.getComponents());
        children.addAll(this.nonExplicitChildrenOf(container));
        return children;
    }

    @Nonnull
    private Collection<Component> nonExplicitChildrenOf(@Nonnull Container c) {
        ArrayList children = Lists.newArrayList();
        for (ChildrenFinderStrategy s : strategies) {
            children.addAll(s.nonExplicitChildrenOf(c));
        }
        return children;
    }

    @Nonnull
    @VisibleForTesting
    static List<ChildrenFinderStrategy> strategies() {
        return Lists.newArrayList(strategies);
    }

    @VisibleForTesting
    static void replaceStrategiesWith(@Nonnull List<ChildrenFinderStrategy> newStrategies) {
        strategies = Lists.newArrayList(newStrategies);
    }
}

