/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.core;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import xsbt.boot.internal.shaded.coursier.core.Authentication$;

public final class Authentication
implements Serializable,
Product {
    private final String user;
    private final Option<String> passwordOpt;
    private final Seq<Tuple2<String, String>> httpHeaders;
    private final boolean optional;
    private final Option<String> realmOpt;
    private final boolean httpsOnly;
    private final boolean passOnRedirect;

    @Override
    public final Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public final String user() {
        return this.user;
    }

    public final Option<String> passwordOpt() {
        return this.passwordOpt;
    }

    public final Seq<Tuple2<String, String>> httpHeaders() {
        return this.httpHeaders;
    }

    public final boolean optional() {
        return this.optional;
    }

    public final Option<String> realmOpt() {
        return this.realmOpt;
    }

    public final boolean httpsOnly() {
        return this.httpsOnly;
    }

    public final boolean passOnRedirect() {
        return this.passOnRedirect;
    }

    public final String toString() {
        return new StringBuilder(32).append("Authentication(").append(this.user()).append(", ****, ").append(this.httpHeaders().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2<Object, String> tuple2;
            if (x0$1 == null) {
                throw new MatchError(tuple2);
            }
            Tuple2<Object, String> k = (String)x0$1._1();
            tuple2 = new Tuple2<Object, String>(tuple2, "****");
            return tuple2;
        })).append(", ").append(this.optional()).append(", ").append(this.realmOpt()).append(", ").append(this.httpsOnly()).append(", ").append(this.passOnRedirect()).append(")").toString();
    }

    public final boolean userOnly() {
        Authentication authentication = Authentication$.MODULE$.apply(this.user());
        return ((Object)this).equals(authentication);
    }

    public final Seq<Tuple2<String, String>> allHttpHeaders() {
        Seq seq = (Seq)Option$.MODULE$.option2Iterable(this.passwordOpt()).toSeq().map((Function1<String, Tuple2> & Serializable)p -> {
            void var1_1;
            Authentication authentication;
            return new Tuple2<String, String>("Authorization", new StringBuilder(6).append("Basic ").append(Authentication$.MODULE$.basicAuthenticationEncode(authentication.user(), (String)var1_1)).toString());
        });
        return (Seq)seq.$plus$plus(this.httpHeaders());
    }

    /*
     * WARNING - void declaration
     */
    public final Authentication withOptional(boolean optional) {
        void var1_1;
        return new Authentication(this.user(), this.passwordOpt(), this.httpHeaders(), (boolean)var1_1, this.realmOpt(), this.httpsOnly(), this.passOnRedirect());
    }

    /*
     * WARNING - void declaration
     */
    public final Authentication withHttpsOnly(boolean httpsOnly) {
        void var1_1;
        return new Authentication(this.user(), this.passwordOpt(), this.httpHeaders(), this.optional(), this.realmOpt(), (boolean)var1_1, this.passOnRedirect());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEqual(Object obj) {
        void var1_1;
        return obj != null && var1_1 instanceof Authentication;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        Authentication other = (Authentication)obj;
        String string = this.user();
        String string2 = other.user();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.passwordOpt();
        Option<String> option2 = other.passwordOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Tuple2<String, String>> seq = this.httpHeaders();
        Seq<Tuple2<String, String>> seq2 = other.httpHeaders();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.optional() != other.optional()) return false;
        Option<String> option3 = this.realmOpt();
        Option<String> option4 = other.realmOpt();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.httpsOnly() != other.httpsOnly()) return false;
        if (this.passOnRedirect() != var1_1.passOnRedirect()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("Authentication");
        code = code * 37 + Statics.anyHash(this.user());
        code = code * 37 + Statics.anyHash(this.passwordOpt());
        code = code * 37 + Statics.anyHash(this.httpHeaders());
        code = code * 37 + (this.optional() ? 1231 : 1237);
        code = code * 37 + Statics.anyHash(this.realmOpt());
        code = code * 37 + (this.httpsOnly() ? 1231 : 1237);
        code = code * 37 + (this.passOnRedirect() ? 1231 : 1237);
        return (int)(var1_1 * 37);
    }

    @Override
    public final String productPrefix() {
        return "Authentication";
    }

    @Override
    public final int productArity() {
        return 7;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object productElement(int n) {
        void var1_1;
        switch (n) {
            case 0: {
                return this.user();
            }
            case 1: {
                return this.passwordOpt();
            }
            case 2: {
                return this.httpHeaders();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean(this.optional());
            }
            case 4: {
                return this.realmOpt();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean(this.httpsOnly());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean(this.passOnRedirect());
            }
        }
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)var1_1)).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Authentication(String user, Option<String> passwordOpt, Seq<Tuple2<String, String>> httpHeaders, boolean optional, Option<String> realmOpt, boolean httpsOnly, boolean passOnRedirect) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.user = var1_1;
        this.passwordOpt = var2_2;
        this.httpHeaders = var3_3;
        this.optional = optional;
        this.realmOpt = realmOpt;
        this.httpsOnly = httpsOnly;
        this.passOnRedirect = passOnRedirect;
        Product.$init$(this);
    }
}

