/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class Shutdown {
    private static final int MAX_SYSTEM_HOOKS = 10;
    private static final Runnable[] hooks = new Runnable[10];
    private static int currentRunningHook = -1;
    private static boolean isShutdown;
    private static Object lock;
    private static Object haltLock;

    Shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(int n, boolean bl, Runnable runnable) {
        if (n < 0 || n >= 10) {
            throw new IllegalArgumentException("Invalid slot: " + n);
        }
        Object object = lock;
        synchronized (object) {
            if (hooks[n] != null) {
                throw new InternalError("Shutdown hook at slot " + n + " already registered");
            }
            if (!bl ? currentRunningHook >= 0 : isShutdown || n <= currentRunningHook) {
                throw new IllegalStateException("Shutdown in progress");
            }
            Shutdown.hooks[n] = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runHooks() {
        Object object = lock;
        synchronized (object) {
            if (isShutdown) {
                return;
            }
        }
        for (int i = 0; i < 10; ++i) {
            Object object2;
            try {
                Runnable runnable;
                object2 = lock;
                synchronized (object2) {
                    currentRunningHook = i;
                    runnable = hooks[i];
                }
                if (runnable == null) continue;
                runnable.run();
                continue;
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) continue;
                object2 = (ThreadDeath)throwable;
                throw object2;
            }
        }
        Object object3 = lock;
        synchronized (object3) {
            isShutdown = true;
        }
    }

    static native void beforeHalt();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void halt(int n) {
        Object object = haltLock;
        synchronized (object) {
            Shutdown.halt0(n);
        }
    }

    static native void halt0(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exit(int n) {
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            if (n != 0 && isShutdown) {
                Shutdown.halt(n);
            }
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.beforeHalt();
            Shutdown.runHooks();
            Shutdown.halt(n);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdown() {
        Class<Shutdown> clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.runHooks();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        lock = new Lock();
        haltLock = new Lock();
    }

    private static class Lock {
        private Lock() {
        }
    }
}

