/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import javax.annotation.Nullable;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.work.Synchronizer;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultSynchronizer
implements Synchronizer {
    private final WorkerLeaseService workerLeaseService;
    private Thread owner;

    public DefaultSynchronizer(WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    public void withLock(Runnable action) {
        Thread previous = this.takeOwnership();
        try {
            action.run();
        }
        finally {
            this.releaseOwnership(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withLock(Factory<T> action) {
        Thread previous = this.takeOwnership();
        try {
            Object object = action.create();
            return (T)object;
        }
        finally {
            this.releaseOwnership(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Thread takeOwnership() {
        final Thread currentThread = Thread.currentThread();
        if (!this.workerLeaseService.isWorkerThread()) {
            throw new IllegalStateException("The current thread is not registered as a worker thread.");
        }
        DefaultSynchronizer defaultSynchronizer = this;
        synchronized (defaultSynchronizer) {
            if (this.owner == null) {
                this.owner = currentThread;
                return null;
            }
            if (this.owner == currentThread) {
                return currentThread;
            }
        }
        this.workerLeaseService.blocking(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultSynchronizer defaultSynchronizer = DefaultSynchronizer.this;
                synchronized (defaultSynchronizer) {
                    while (DefaultSynchronizer.this.owner != null) {
                        try {
                            DefaultSynchronizer.this.wait();
                        }
                        catch (InterruptedException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                    }
                    DefaultSynchronizer.this.owner = currentThread;
                }
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOwnership(Thread previousOwner) {
        DefaultSynchronizer defaultSynchronizer = this;
        synchronized (defaultSynchronizer) {
            this.owner = previousOwner;
            this.notifyAll();
        }
    }
}

