/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientProtocolCondition;

public class ClientProtocolConditionFactory
implements ClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "client-type";
    private List<String> loginProtocols;

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new ClientProtocolCondition(session);
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            this.loginProtocols = new LinkedList<String>(session.listProviderIds(LoginProtocol.class));
        }
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Condition that uses the client's protocol (OpenID Connect, SAML) to determine whether the policy is applied.";
    }

    public void init(Config.Scope config) {
    }

    public void close() {
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("protocol").type("List").options(this.loginProtocols).defaultValue((Object)this.loginProtocols.iterator().next()).label("Client protocol").helpText("What client login protocol the condition will apply on.").add().build();
    }
}

